#TRUSTED 40a49b8fcafdafe2dc800806a8dab4797ca2ffdef40a9973d2a5b829c87ef4f22ee0b423fbec03babe8b1a901c85dab9d1e88c966ad64b72aac0444bf81c65dfa4bec1a0044746db15f43ad4a58914ca8d6b1f8d47123e96250db116394af81a0c7041b410b2ed9a6baa354c710ef03645262c6c57a0082b1612e552767a47a0c5ac544ffe1ffea1f7ec178c51fdfd238f6006f431bc55b31ef591756eefe0bc19c20210ea6d88cc5f42b33e53910df48d436395b504eb23dbe47c773a6ba9476d8c0300240b1c37452555f03fb5afe39524e7413f2a522c327092cf613b556250831d9287e0a3fee61e464c90738b9683cb4c600d261435726fa77a22a7e3a0e0b39566781887231d4fde0d45a7ced77e54c609e9078c77cd23eec32f14b6e71dc2dcbd270e57fa9c6cb84538c4a9d3888ce26dd150eee52b0c4af437a8f2a8e6ea425f877886af0c52ba392196f2c02669918c3d1524f7ceaf3a7ee97487d4dfe5dd904574fdf44a7066f776c545e0de3ba809ce8762b3a8b50ee0f42ce1d0b4cd72e23bea5be573c07db9d3f78be91ee6a23b789b9766561d0f7164b8a83bf878f179e1aaa7eec375368142d77b118ea817ab7b7e22cdab1c1d73850d457e3d943bd705250117bce8aed283443e34d8911f43d54666828a3251f0ec120fc34170064e45ad3bbd4ab9c87d42f60ea642bb171cc2bf6876d4e8237fe1821623
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15879);
 script_version ("1.2");
 name["english"] = "Hydra: NNTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find NNTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force NNTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/nntp", 119);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/nntp");
if (! port) port = 119;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "nntp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/nntp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following NNTP accounts:\n' + report);
