/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 *
 * nemesis-igmp.c (IGMP Packet Injector)
 *
 */

#include "nemesis-igmp.h"

int
main(int argc, char **argv)
{
   int             opt;
   char           *file = NULL;
   static int      fd = -1;
   char            buff[512];
   extern char    *optarg;
   extern int      opterr;

   got_link = 0;
   got_options = 0;
   got_payload = 0;

   verbose = 0;

   if (argc < 2)
      usage(argv[0]);

   defaults();

   opterr = 0;
   while ((opt = getopt(argc, argv, "S:D:d:F:H:M:p:c:i:I:T:t:O:P:v")) != EOF) {
      switch (opt) {
      case 'v':
	 verbose = 1;
	 putchar('\n');
	 puts(TITLE " " VERSION);
	 puts(CODERS);
	 putchar('\n');
	 break;
      case 'S':
	 if (!(source = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid source IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[IP]  %s > ", optarg);
	 break;
      case 'D':
	 if (!(dest = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("%s\n", optarg);
	 break;
      case 'i':
	 if (!(iip = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid IGMP group address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[IGMP Group Address] %s\n", optarg);
	 break;
      case 'p':
	 type = atoi(optarg);
	 break;
      case 'c':
	 code = atoi(optarg);
	 break;
      case 'F':
	 frag = atoi(optarg);
	 break;
      case 'd':
	 got_link = 1;
	 device = optarg;
	 break;
      case 'H':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
	    enet_src[0] = (u_char) enet_tmp[0];
	    enet_src[1] = (u_char) enet_tmp[1];
	    enet_src[2] = (u_char) enet_tmp[2];
	    enet_src[3] = (u_char) enet_tmp[3];
	    enet_src[4] = (u_char) enet_tmp[4];
	    enet_src[5] = (u_char) enet_tmp[5];
	 }
	 break;
      case 'M':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
	    enet_dst[0] = (u_char) enet_tmp[0];
	    enet_dst[1] = (u_char) enet_tmp[1];
	    enet_dst[2] = (u_char) enet_tmp[2];
	    enet_dst[3] = (u_char) enet_tmp[3];
	    enet_dst[4] = (u_char) enet_tmp[4];
	    enet_dst[5] = (u_char) enet_tmp[5];
	 }
	 break;
      case 'I':
	 id = atoi(optarg);
	 break;
      case 'T':
	 ttl = atoi(optarg);
	 break;
      case 't':
	 tos = strtoul(optarg, NULL, 0);
	 break;
      case 'P':
	 file = optarg;
	 got_payload = 1;
	 if ((fd = open(file, O_RDONLY)) < 0) {
	    (void) fprintf(stderr, "%s: open: ", argv[0]);
	    perror(file);
	    exit(-1);
	 }
	 break;
      case 'O':
	 got_options = 1;
	 (u_char) * options = strtoul(optarg, NULL, 0);
	 break;
      case '?':
	 usage(argv[0]);
	 break;
      }
   }
   argc -= optind;
   argv += optind;

   if (source == 0 || dest == 0) {
      printf("Source and/or Destination Address Missing.\n");
      exit(1);
   }
   if (verbose) {
      printf("[IGMP Type] %d\n", type);
      printf("[IGMP Code] %d\n", code);

      printf("[IP ID] %d\n", id);
      printf("[IP TTL] %d\n", ttl);
      printf("[IP TOS] 0x%x\n", tos);
      printf("[IP Frag] 0x%x\n", frag);
      printf("[IP Options] %s\n\n", options);
   }
   if (got_payload) {
      payload = buff;
      while ((nbytes = read(fd, buff, sizeof(buff))) != 0) {
	 payload_s += nbytes;
	 if (verbose) {
	    hexdump(payload, payload_s);
	    if (buildigmp() != -1) {
	       if (verbose)
		  printf("\nIGMP Packet Injected\n");
	    } else {
	       if (verbose)
		  printf("\nIGMP Injection Failure\n");
	    }
	 }
      }
      close(fd);
      exit(0);
   }
   if (buildigmp() != -1) {
      if (verbose)
	 printf("\nIGMP Packet Injected\n");
   } else {
      if (verbose)
	 printf("\nIGMP Injection Failure\n");
   }
   close(fd);
   exit(0);
}

void 
hexdump(char *buf, int len)
{
   int             i, j, ptr, pad = PADDING, counter;
   ptr = 0;
   counter = 0;
   for (i = 0; i < len; i++) {
      counter++;
      printf("%02X ", (u_char) buf[i]);
      if ((i == (len - 1)) && (counter < pad))
	 while (counter++ < pad)
	    printf("   ");
      if (((i + 1) % pad == 0) || (i == (len - 1))) {
	 counter = 0;
	 for (j = ptr; j <= i; j++) {
	    if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
	       printf("%c", buf[j]);
	    } else {
	       putchar('.');
	    }
	 }
	 ptr = i + 1;
	 putchar('\n');
      }
   }
   putchar('\n');
}

void
usage(char *arg)
{
   putchar('\n');
   puts(TITLE " " VERSION);
   puts(CODERS);
   putchar('\n');

   printf("IGMP usage:\n  %s [-v] [options]\n\n", arg);
   printf("IGMP options: \n"
	  "  -p <IGMP Type>\n"
	  "  -c <IGMP Code>\n"
	  "  -i <IGMP Group Address>\n"
	  "  -P <Payload File (Binary or ASCII)>\n"
	  "  (-v VERBOSE - packet struct to stdout)\n\n");
   printf("IP options: \n"
	  "  -S <Source IP Address>\n"
	  "  -D <Destination IP Address>\n"
	  "  -I <IP ID>\n"
	  "  -T <IP TTL>\n"
	  "  -t <IP tos>\n"
	  "  -F <IP frag>\n"
	  "  -O <IP Options>\n\n");
   printf("Data Link Options: \n"
	  "  -d <Ethernet Device>\n"
	  "  -H <Source MAC Address>\n"
	  "  -M <Destination MAC Address>\n\n");
   printf("You must define a Source, Destination and Protocol Options.\n");
   exit(1);
}

void
defaults()
{
   enet_src[0] = 0x02;
   enet_src[1] = 0x0f;
   enet_src[2] = 0x0a;
   enet_src[3] = 0x0d;
   enet_src[4] = 0x0e;
   enet_src[5] = 0x0d;

   enet_dst[0] = 0x0d;
   enet_dst[1] = 0x0e;
   enet_dst[2] = 0x0a;
   enet_dst[3] = 0x0d;
   enet_dst[4] = 0x00;
   enet_dst[5] = 0x01;

   type = 1;
   code = 1;
   iip = 0;
   id = 0;
   tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
   ttl = 1;
   payload = NULL;
   payload_s = 0;
   *options = NULL;
   option_s = 0;
   frag = IP_DF;
}
