/* 
 * $Id: nemesis-ospf.h,v 1.2 2000/06/24 18:45:03 obecian Exp $
 *
 * THE NEMESIS PROJECT (c) obecian 1999, 2000
 *
 * nemesis-ospf.h (OSPF Packet Injector)
 *
 */


#define TITLE "OSPF Packet Injection -=- The NEMESIS Project"
#define VERSION "1.1"
#define CODERS "(c) 1999, 2000 obecian <obecian@celerity.bartoli.org>"

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <libnet.h>
#include <pcap.h>

#define PROMISC 1
#define SNAPLEN 128
#define TIMEOUT 1024
#define OPTIMIZE 0
#define PADDING 15

u_short         id,		/* IP id */
                frag,		/* frag shit */
				mtusize,	/* Max dgram length (DBD) */
				num,		/* LSA_RTR num */
                interval,	/* secs since last pkt sent */
				rtr_flags,	/* LSA_RTR flags */
				metric,		/* OSPF metric */
                ospf_age;	/* OSPF advertisement age */
u_long          source,		/* source address */
                dest,		/* destination address */
                neighbor,	/* neighbor router */
				as_fwd,		/* AS_EXT forward address */
                addrid,		/* advertising router id */
                addaid,		/* advertising area id */
                router,		/* advertising router */
                auth[2],	/* authentication type */
                mask;		/* subnet mask (icmp_mask) */
u_char          enet_src[6],	/* source MAC address */
                enet_dst[6],	/* destination MAC address */
                ttl,		/* time to live */
                tos,		/* type of service */
               *payload,	/* payload pointer */
                options[40],	/* IP options pointer */
                priority,	/* OSPF priority */
			 	exchange,	/* DBD exchange type */
				rtrtype,	/* LSA_RTR type */
                ooptions;	/* OSPF options */
u_int           enet_tmp[6], /* temp typecast array */
				dead_int,	/* dead router interval in secs */
				as_tag,		/* AS_EXT tag */
                seqnum,		/* seqnum for LSA */
				bcastnum,	/* num of LSAs to bcast (LSU) */
				rtrdata,	/* LSA_RTR router data */
                rtrid;		/* router id for LSA */

int             got_link, got_options, got_payload;	/* sanity checks */

int             option_s;	/* IP options size */
int             payload_s;	/* payload size */
int             ospftype;	/* which OSPF packet to launch */

char           *device;		/* network device */

int             verbose;	/* verbosity */

int             buildospf(); /* OSPF Protocol wrapper */
int             build_hello(); /* Hello (discover/maintain neighbors) */
int				build_dbd(); /* Database Description (summarize db contents) */
int				build_lsr(); /* Link State Request (db d/l) */
int				build_lsu(); /* Link State Update (db update) */
int				build_lsartr(); /* Router Links Advertisment */
int				build_lsanet(); /* Network Links Advertisement */
int				build_lsasum_ip(); /* Summary Links Advertisement */
int				build_lsaas();  /* AS Ext Link Advertisement */

void						hexdump(char *, int);
void            usage(char *);
void            defaults();	/* defaults for packet fields */

int             nbytes;

#ifndef IPOPT_SECURITY
#define IPOPT_SECURITY	130
#endif
