/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#define USE_COLORS

#ifdef __CYGWIN32__
  #define setbuffer(s, b, t) setvbuf(s, b, b ? _IOFBF : _IONBF, t)
  
  #define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
  #define	timerclear(tvp)		((tvp)->tv_sec = (tvp)->tv_usec = 0)

  #define socklen_t int

  /* make up for an apparent bug in cygwin ncurses implementation */
  #undef ACS_VLINE
  #undef ACS_HLINE
  #define ACS_VLINE '|'
  #define ACS_HLINE '-'
#endif


typedef int (*ucmd_func_t)();

/* some static limits */
#define MAXCHANS 5
#define TABSIZE 5
#define BACKLOG 32

/* incomplete files of this size or less are considered "turds" and
   will be removed. This is the default value; the actual value can be
   overridden by the turdsize user variable. */
#define TURDSIZE 100000

/* the default port for napster servers */
#define PORT 8875

/* where to get news about new versions of this client */
#define NEWSURL "http://theory.stanford.edu/~selinger/nap/UPDATE"
#define NEWSTIMEOUT 5

/* default for the "connecttimeout" variable */
#define CONNECTTIMEOUT 5

/* where to get information about servers, napigator-style */
#define METASERVER "http://www.napigator.com/servers.php"
#define METATIMEOUT 5

/* the client name which we send to the server on login. It may be
   necessary to lie here, as certain OpenNap servers have been known
   to be nasty to nap ("bad client"). Add command line option "--lie"
   in the future? */
#define CLIENT VERSION

/* some file names for standard files. These filenames are relative to
   the user's home directory, unless noted otherwise. */

#define CONFIGDIR   ".nap"
#define CONFIGFILE  CONFIGDIR "/napconf"
#define LIBRARYFILE CONFIGDIR "/shared"
#define HOTLISTFILE CONFIGDIR "/hotlist-%s"  /* %s is user name */
#define ALIASFILE   CONFIGDIR "/aliases"
#define HANDLERFILE CONFIGDIR "/handlers"
#define CHANNELFILE CONFIGDIR "/channels-%s" /* %s is user name */

/* library file header, must change when the file format changes */
#define NAP_LIBRARY_HEADER \
  "NAP LIBRARY FILE v01. Automatically generated file, do not edit."

/* markers that are used to add checksum tags to incomplete files */
#define INCTAG_START "<NAP incomplete tag "
#define INCTAG_END   " end incomplete tag NAP>"

#ifndef MCURSES
  #define newwin(n, l, c, y, x) (newwin(l, c, y, x))
#endif

