/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>

#include "defines.h"
#include "colors.h"
#include "codes.h"
#include "scheck.h"
#include "nap.h"
#include "sscr.h"


extern ssearch_t *search;
extern file_t *down;
extern unsigned char finp;
extern char *conns[];
extern int curx;
extern WINDOW *winput, *wchan;

int cx, cy, num, lk, max;
WINDOW *swin;
char *status;
void *cbk;


void sscr(ssearch_t *l)
{
  sock_t *cur;
  
  cur = findsock("input");
  cbk = cur->d;
  finp = 1;
  
  addsock(0, "sinput", S_R, sinput);
  findsock("sinput")->d = (void *)l;
  
  swin = newwin("sscr", LINES, 0, 0, 0);
  wbkgdset(swin, COLOR_PAIR(CPW));
  keypad(swin, TRUE);
  werase(swin);
  drw(swin);
  
  cx = cy = num = max = 0;
  status = strdup("Use F1 or 'q' to return to the main screen");
  lk = 1;
  
  plist(l, swin, cy);
}

void plist(ssearch_t *l, WINDOW *w, int n)
{
  int i, c, ln=0, p, z=n, min, sec;
  ssearch_t *cur;
  char *t=NULL, *ping=NULL, *sp=NULL;
  
  if (!finp)
    return;
  
  if (!l || l->num == -1)
  {
    werase(w);
    wprintw(w, "No search results to list");
    wrefresh(w);
    return;
  }
  
  for (c=0,cur=l;cur;cur=cur->next)
    if (cur->num > c)
      c = cur->num;
  
  if (num > c)
    num = c;
  if (n > c)
    return;
  
  max = c;

  if (num > ((LINES-3)+cy-1))
  {
    if (num <= (LINES-3))
      cy++;
    else
      cy += num-(LINES-3)-cy+1;
    z = cy;
  }
  if (num < cy)
  {
    cy -= cy-num;
    z = cy;
  }
  
  werase(w);
  
  mvwprintw(w, 0, 0, "Filename");
  wmove(w, 1, 0);
  whline(w, ACS_HLINE, COLS);
  sp = (char *)malloc((COLS/2)/3-4+1);
  memset(sp, ' ', (COLS/2)/3-4);
  sp[(COLS/2)/3-4] = 0;
  mvwprintw(w, 0, COLS/2+3, "BRate%sLength%s", sp, sp);
  if (l->conn == -1)
    wprintw(w, "");
  else if (l->ping == -2)
    wprintw(w, "Conn");
  else
    wprintw(w, "Ping");
  wmove(w, 0, COLS/2+1);
  wvline(w, ACS_VLINE, LINES-1);
  wmove(w, 0, COLS/2+strlen(sp)+7-1);
  wvline(w, ACS_VLINE, LINES-1);
  wmove(w, 0, COLS/2+strlen(sp)*2+13-1);
  wvline(w, ACS_VLINE, LINES-1);
  
  for (i=c-z,ln=0,p=1;ln<(LINES-3);i--,ln++,p=1,t=ping=NULL)
  {
    for (cur=l;cur&&cur->num!=i;cur=cur->next);
    if (cur)
    {
      if ((c-i+1) < 10)
        p++;
      else if ((c-i+1) < 100)
        p += 2;
      else if ((c-i+1) < 1000)
        p += 3;
      
      if (cur->conn == -1)
        msprintf(&ping, "");
      else if (cur->ping == -2)
        msprintf(&ping, "%s", conns[cur->conn]);
      else if (cur->ping == -1)
        msprintf(&ping, "N/A");
      else
        msprintf(&ping, "%i", cur->ping);
        
      min = cur->time/60;
      sec = cur->time%60;
      
      if (num == (c-i))
      {
        wattron(w, COLOR_PAIR(1)|A_BOLD);
        wmove(w, ln+2, 0);
        whline(w, ' ', COLS);
        if (!lk)
        {
          if (status)
            free(status);
          status = strdup(cur->fn);
        }
      }
        
      t = (char *)malloc(COLS/2-p);
      memset(t, 0, COLS/2-p);
      strncpy(t, cur->song, COLS/2-p-1);
      t[COLS/2-p-1] = 0;
      mvwprintw(w, ln+2, 0, "%i) %s", c-i+1, t);
      mvwprintw(w, ln+2, COLS/2+3, "%i", cur->brate);
      mvwprintw(w, ln+2, COLS/2+strlen(sp)+7+1, "%i:%02i", min, sec);
      mvwprintw(w, ln+2, COLS/2+strlen(sp)*2+13+1, ping);
      free(t);
      
      if (num == (c-i))
      {
        wmove(w, ln+2, COLS/2+1);
        wvline(w, ACS_VLINE, 1);
        wmove(w, ln+2, COLS/2+strlen(sp)+7-1);
        wvline(w, ACS_VLINE, 1);
        wmove(w, ln+2, COLS/2+strlen(sp)*2+13-1);
        wvline(w, ACS_VLINE, 1);
        wattroff(w, COLOR_PAIR(1)|A_BOLD);
      }
      free(ping);
    }
    else
      break;
  }
  
  if (status)
  {
    if (strlen(status) < COLS)
    {
      cx = 0;
      status = (char *)realloc(status, COLS+1);
    }
    if (strlen(status+cx) < COLS && cx)
      cx = strlen(status)-COLS;
    strncpy(status, status+cx, COLS);
    status[COLS] = 0;
  }
  
  wattron(w, COLOR_PAIR(CPBR));
  if (!status)
    status = strdup("Status");
  wmove(w, LINES-1, 0);
  whline(w, ' ', COLS);
  waddstr(w, status);
  wattroff(w, COLOR_PAIR(CPBR));
  
  free(sp);
 
  drw(w);
}

int sinput(WINDOW *win, sock_t *m)
{
  chtype cbuf = 0;
  WINDOW *w = swin;
  sock_t *sk;
  ssearch_t *cur;
  
  cbuf = wgetch(w);
  
  if (cbuf == KEY_F(1))
  {
    uscr();
    return(0);
  }
  else if (cbuf == KEY_UP)
  {
    num--;
    if (num < 0)
      num = 0;
    cx = lk = 0;
  }
  else if (cbuf == KEY_DOWN)
  {
    num++;
    cx = lk = 0;
  }
  else if (cbuf == KEY_RIGHT)
    cx++;
  else if (cbuf == KEY_LEFT)
  {
    cx--;
    if (cx < 0)
      cx = 0;
  }
  else if (cbuf == KEY_PPAGE || cbuf == 5)
  {
    num-=5;
    if (num < 0)
      num = 0;
    cx = lk = 0;
  }
  else if (cbuf == KEY_NPAGE || cbuf == 4)
  {
    num+=5;
    cx = lk = 0;
  }
  else if (cbuf == 'q')
  {
    uscr();
    return(0);
  }
  else if (cbuf == '\n' && max)
  {
    lk = 1;
    for (cur=search;cur;cur=cur->next)
      if ((max-num) == cur->num)
        break;
    if (status)
      free(status);
    status = NULL;
    sk = findsock("server");
    if (sk)
    {
      if (tlist(down, cur->cmp, cur->song))
        msprintf(&status, "Already downloading %s", cur->song);
      else
      {
        msprintf(&status, "Downloading %s", cur->song);
        sendpack(sk->s, F_DGET, "%s \"%s\"", cur->cmp, cur->fn);
      }
    }
  }
  
  plist(m->d, swin, cy);
  
  return(1);
}

void uscr()
{
  delwin(swin);
  
  addsock(0, "input", S_R, input);
  findsock("input")->d = cbk;
  finp = 0;
  
  if (status)
    free(status);
  
  dscr(wchan);
  drw(wchan);
  dstatus();
  indraw(cbk, curx, winput);
  drw(winput);
}
