/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#ifndef MCURSES
#include <ncurses.h>
#endif
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <errno.h>

#include "defines.h"
#include "codes.h"
#include "colors.h"
#include "scheck.h"
#include "timer.h"

#ifdef MCURSES
#include "wind.h"
#endif


extern int srch;
extern WINDOW *wchan;
extern unsigned char dx[], ux[];

static sock_t *head = NULL;
unsigned char finp = 0;


void addsock(int s, char *nm, unsigned char t, int (*func)(WINDOW *, sock_t *))
{
  sock_t *cur, *cur1, *sv;
  
  if (head)
  {
    for (cur=head,cur1=NULL;cur!=NULL;cur=cur->next)
      cur1 = cur;
    cur = (sock_t *)malloc(sizeof(sock_t));
    cur1->next = cur;
  }
  else
  {
    head = (sock_t *)malloc(sizeof(sock_t));
    cur = head;
  }
  cur->s = s;
  cur->t = t;
  cur->nm = strdup(nm);
  cur->func = func;
  cur->next = NULL;
  cur->d = NULL;
  
  sv = findsock("server");
  if (sv)
  {
    if (cur->nm[0] == 'u' && cur->nm[1] == ' ')
      sendpack(sv->s, F_UP, NULL);
    if (cur->nm[0] == 'd' && cur->nm[1] == ' ')
      sendpack(sv->s, F_DOWN, NULL);
  }
}

void delsock(int s)
{
  int i;
  sock_t *cur, *cur1=NULL, *sv;
  
  sv = findsock("server");
  
  for (i=0,cur=head;cur!=NULL;cur=cur->next)
  {
    if (cur->s == s)
    {
      if (cur->nm[0] == 'd' && cur->nm[1] == ' ')
      {
        if (sv)
          sendpack(sv->s, F_DOWNDONE, NULL);
        dx[atoi(cur->nm+2)] = 0;
      }
      if (cur->nm[0] == 'u' && cur->nm[1] == ' ')
      {
        if (sv)
          sendpack(sv->s, F_UPDONE, NULL);
        ux[atoi(cur->nm+2)] = 0;
      }
      if (!strcmp(cur->nm, "server"))
        srch = 0;
      if (cur1)
        cur1->next = cur->next;
      else if (cur->next)
        head = cur->next;
      else
        head = NULL;
      free(cur->nm);
      free(cur);
      if (s > 2)
      {
        shutdown(s, 2);
        close(s);
      }
      return;
    }
    cur1 = cur;
  }
}

sock_t *findsock(char *nm)
{
  sock_t *cur;
  
  for (cur=head;cur!=NULL;cur=cur->next)
    if (!strcasecmp(nm, cur->nm))
      return(cur);
  
  return(NULL);
}

void psocks(WINDOW *win)
{
  sock_t *cur;
  int c;
  
  for (cur=head,c=1;cur!=NULL;cur=cur->next,c++)
    wp(win, "%s\n", cur->nm);
  drw(win);
}

void sockfunc(WINDOW *win, WINDOW *up)
{
  fd_set fs, fw;
  int r;
  sock_t *cur;
  struct timespec sec;
  
  while (1)
  {
    dochecks();
    drw(up);
    FD_ZERO(&fs);
    FD_ZERO(&fw);
    
    if (!head)
      return;
    else if (!strcasecmp(head->nm, "input") && !head->next)
    {
      delsock(head->s);
      return;
    }
    
    for (cur=head;cur!=NULL;cur=cur->next)
    {
      if (cur->t == S_R)
        FD_SET(cur->s, &fs);
      else if (cur->t == S_W)
        FD_SET(cur->s, &fw);
    }
    
    sec.tv_nsec = 0;
    sec.tv_sec = 1;
    
    r = select(FD_SETSIZE, &fs, &fw, NULL, (struct timeval *)&sec);
    tevent(0);
    if (r <= 0)
      continue;
    
    for (cur=head;cur!=NULL;cur=cur->next)
    {
      if (cur->t == S_R && FD_ISSET(cur->s, &fs))
      {
        r = cur->func(win, cur);
        if (!r)
        {
          FD_CLR(cur->s, &fs);
          delsock(cur->s);
        }
        else if (r == -1)
        {
          while (head!=NULL)
            delsock(head->s);
          return;
        }
        else
          FD_CLR(cur->s, &fs);
        cur = head;
      }
      else if (cur->t == S_W && FD_ISSET(cur->s, &fw))
      {
        r = cur->func(win, cur);
        if (!r)
        {
          FD_CLR(cur->s, &fw);
          delsock(cur->s);
        }
        else if (r == -1)
        {
          while (head!=NULL)
            delsock(head->s);
          return;
        }
        else
          FD_CLR(cur->s, &fw);
        cur = head;
      }
    }
  }
}

void sockfunct(WINDOW *win, WINDOW *up, int sec)
{
  fd_set fs, fw;
  int r, adj=0;
  sock_t *cur;
  struct timespec tv;
  time_t t, t1;
  
  while (1)
  {
    tv.tv_sec = sec-adj;
    tv.tv_nsec = 0;
    if (tv.tv_sec <= 0)
      return;
      
    dochecks();
    drw(up);
    FD_ZERO(&fs);
    FD_ZERO(&fw);
    
    if (!head)
      return;
    else if (!strcasecmp(head->nm, "input") && !head->next)
    {
      delsock(head->s);
      return;
    }
    
    for (cur=head;cur!=NULL;cur=cur->next)
    {
      if (cur->t == S_R)
        FD_SET(cur->s, &fs);
      else if (cur->t == S_W)
        FD_SET(cur->s, &fw);
    }
    
    time(&t);
    
    r = select(FD_SETSIZE, &fs, &fw, NULL, (struct timeval *)&tv);
    tevent(0);
    if (r == -1)
      continue;
    else if (!r)
      return;
    
    time(&t1);
    
    adj+=(t1-t);
    
    for (cur=head;cur!=NULL;cur=cur->next)
    {
      if (cur->t == S_R && FD_ISSET(cur->s, &fs))
      {
        r = cur->func(win, cur);
        if (!r)
        {
          FD_CLR(cur->s, &fs);
          delsock(cur->s);
        }
        else if (r == -1)
        {
          while (head!=NULL)
            delsock(head->s);
          return;
        }
      }
      else if (cur->t == S_W && FD_ISSET(cur->s, &fw))
      {
        r = cur->func(win, cur);
        if (!r)
        {
          FD_CLR(cur->s, &fw);
          delsock(cur->s);
        }
        else if (r == -1)
        {
          while (head!=NULL)
            delsock(head->s);
          return;
        }
      }
    }
  }
}
