/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>

#include "md5.h"
#include "mp3s.h"


int brate1[] = { 0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1 };
int brate2[] = { 0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1 };

int freq1[] = { 44100, 48000, 32000, 50000 };
int freq2[] = { 22050, 24000, 16000, 50000 };


int checkhdr(hdr_t *h)
{
  if (h->sync != 0xfff ||
      h->layer != 1 ||
      h->brate == 15 ||
      h->freq == 3 ||
      h->emph == 2)
    return(0);
  
  return(1);
}

hdr_t *getrhdr(int f)
{
  hdr_t *r = (hdr_t *)malloc(sizeof(hdr_t));
  unsigned char *fw = (char *)r, bw[4];
  
  read(f, bw, sizeof(bw));
  
  fw[0] = bw[3];
  fw[1] = bw[2];
  fw[2] = bw[1];
  fw[3] = bw[0];
  
  if (!checkhdr(r))
  {
    free(r);
    return(NULL);
  }
  
  return(r);
}

mhdr_t *gethdr(char *fn)
{
  hdr_t *m;
  mhdr_t *r;
  int f, i;
  unsigned long size = 0;
  struct stat st;
  id3v2_t tag;
  char *buf, rdt[4];
  struct
  {
    unsigned char t:4, b:4;
  } ret[16];
  
  f = open(fn, O_RDONLY);
  if (f == -1)
    return(NULL);
  
  memset(rdt, 0, sizeof(rdt));
  read(f, &rdt, 3);
  if (!strcmp(rdt, "ID3"))
  {
    lseek(f, 0, SEEK_SET);
    read(f, &tag, sizeof(tag));
    size = (long)tag.size[0] << (24-1)|(long)tag.size[1] << (16-1)|(long)tag.size[2] << (8-1)|(long)tag.size[3];
    lseek(f, size+sizeof(tag), SEEK_SET);
  }
  else
  {
    memset(rdt, 0, sizeof(rdt));
    lseek(f, 0, SEEK_SET);
  }
  m = getrhdr(f);
  if (!m)
  {
    close(f);
    return(NULL);
  }
  
  r = (mhdr_t *)malloc(sizeof(mhdr_t));
  memset(r, 0, sizeof(mhdr_t));
  
  if (m->id)
  {
    r->bitrate = brate1[m->brate];
    r->freq = freq1[m->freq];
  }
  else
  {
    r->bitrate = brate2[m->brate];
    r->freq = freq2[m->freq];
  }
  
  free(m);
  
  fstat(f, &st);
  
  r->len = ((st.st_size*8)/r->bitrate)/1000;
  r->sz = st.st_size;
  
  buf = (char *)malloc(300000);
  memset(buf, 0, 300000);
  if (*rdt)
    lseek(f, size+sizeof(tag), SEEK_SET);
  else
    lseek(f, 0, SEEK_SET);
  read(f, buf, 300000);
  close(f);
  
  memset(ret, 0, sizeof(ret));
  md5_buffer(buf, 300000, &ret);
  free(buf);
  
  memset(r->check, 0, sizeof(r->check));
  
  for (i=0;i<16;i++)
    sprintf(r->check, "%s%x%x", r->check, ret[i].b, ret[i].t);
  
  r->check[32] = '\0';
  
  return(r);
}
