/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#define USE_COLORS

#ifdef __CYGWIN32__
/* Note: this is not needed any more - use <select.h> timeval, not 
   <time.h> timespec. -PS */
/*
  struct timespec
  {
    long int tv_sec;
    long int tv_nsec;
  }; 
*/
  
  #define setbuffer(s, b, t) setvbuf(s,  b,  b  ?  _IOFBF   :   _IONBF, t)
  
  #define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
  #define	timerclear(tvp)		((tvp)->tv_sec = (tvp)->tv_usec = 0)
#endif


typedef int (*ucmd_func_t)();

/* up- and download limits are now handled entirely dynamically - no more
   MAXUPLOADS and MAXDOWNLOADS. See info.maxuploads and gnum().  -PS */
#define MAXCHANS 5
#define TABSIZE 5
#define BACKLOG 32

/* the default port for napster servers */
#define PORT 8875

#define SHOST "127.0.0.1"
#define SPORT 9999
#define LPORT 9998

#define CONF ".napconf"
#define CLIENT VERSION
#define SFILE ".nap_shared"
#define USERLIB "./cmdslib.so"

#define S_R 0x1
#define S_W 0x2


#ifndef MCURSES
  #define newwin(n, l, c, y, x) (newwin(l, c, y, x))
#endif


#define F_OP 1
#define F_VOICE 2

#define F_I 1
#define F_S 2
#define F_P 4
#define F_L 8
#define F_K 16
#define F_T 32
#define F_M 64
#define F_N 128
