<?php
/*
 * $Horde: nag/view.php,v 1.14.2.1 2002/03/19 02:06:21 chuck Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* If we aren't provided with a task, redirect to the task list. */
$task_id = Horde::getFormData('task');
if (!isset($task_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Nag storage instance. */
require_once NAG_BASE . '/lib/Driver.php';
$storage = &Nag_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Get the current task list. */
$tasks = Nag::listTasks($storage);

/* Set the page title to the current task's name, if it exists. */
$title = (!empty($tasks[$task_id])) ? $tasks[$task_id]['name'] : _("Task Details");

$js_onLoad = null;
require NAG_TEMPLATES . '/common-header.inc';
require NAG_BASE . '/menu.php';
$notification->notify();

/* If the requested task doesn't exist, display an error message. */
if (!isset($tasks[$task_id])) {
    include NAG_TEMPLATES . '/view/no-task.inc';
} else {
    include NAG_TEMPLATES . '/view/headers.inc';
    include NAG_TEMPLATES . '/view/description.inc';
    include NAG_TEMPLATES . '/view/navbar.inc';
}

require NAG_TEMPLATES . '/common-footer.inc';

?>
