
// This file contains common TUT test cases for myx_recordet.c
//
//

//----------------------------------------------------------------------------------------------------------------------

#include "test.h"
#include "myx_public_interface.h"
#include "myx_library.h"


#include <m_ctype.h> 
// Private test data.
BEGIN_TEST_DATA_CLASS(module6_recordset_test)
protected:
  Test_connection* connection;
END_TEST_DATA_CLASS

//----------------------------------------------------------------------------------------------------------------------

TEST_MODULE(module6_recordset_test, "Recordset test, base library");


//----------------------------------------------------------------------------------------------------------------------

TEST_FUNCTION(5)
{
  connection= test_group_singleton.get_connection();

  ensure("Valid server connection", connection != NULL);
}

//----------------------------------------------------------------------------------------------------------------------

static const char *big_rs_query= "select * from sakila.payment, sakila.staff_list";
static const char *not_so_big_rs_query= "select * from sakila.film";

// bug #11070
// memory usage limit handler
TEST_FUNCTION(10)
{
  unsigned int old_limit= myx_mysql_get_resultset_size_limit(connection->get_mysql());
  MYX_RESULTSET *rset;
  MYX_LIB_ERROR err;

  myx_mysql_limit_resultset_size(connection->get_mysql(), 1); // 1MB

  // check if it aborts the query
  rset= myx_query_execute(connection->get_mysql(),
                          big_rs_query,
                          0,
                          NULL,
                          &err, NULL,
                          NULL,
                          NULL,
                          NULL);

  ensure_equals("big query with memory limit", err, MYX_MEMORY_LIMIT_EXCEEDED);
  ensure("big query with memory limit", rset != NULL);
  myx_query_free_resultset(rset);

  // check if a smaller resultset runs ok
  rset= myx_query_execute(connection->get_mysql(),
                          not_so_big_rs_query, 
                          0,
                          NULL,
                          &err, NULL,
                          NULL,
                          NULL,
                          NULL);

  ensure_equals("small query with memory limit", err, MYX_NO_ERROR);
  ensure("small query with memory limit", rset != NULL);
  puts(mysql_error(connection->get_mysql()));
  myx_query_free_resultset(rset);

  myx_mysql_limit_resultset_size(connection->get_mysql(), old_limit);

  // check if it runs ok without the limit
  rset= myx_query_execute(connection->get_mysql(),
                          big_rs_query, 
                          0,
                          NULL,
                          &err, NULL,
                          NULL,
                          NULL,
                          NULL);

  ensure_equals("big query without memory limit", err, MYX_NO_ERROR);
  ensure("big query without memory limit", rset != NULL);
  myx_query_free_resultset(rset);
}

//----------------------------------------------------------------------------------------------------------------------

TEST_FUNCTION(15)
{
  ubigint result= myx_bit_to_int(NULL);
  ensure_equals("Convert BIT to integer", result, -1);

  result= myx_bit_to_int("");
  ensure_equals("Convert BIT to integer", result, -1);

  result= myx_bit_to_int("31");
  ensure_equals("Convert BIT to integer", result, 31);

  result= myx_bit_to_int("b'11100'");
  ensure_equals("Convert BIT to integer", result, 28);

  result= myx_bit_to_int("0xFFFE");
  ensure_equals("Convert BIT to integer", result, 65534);

  result= myx_bit_to_int("0xabcde");
  ensure_equals("Convert BIT to integer", result, 703710);

  result= myx_bit_to_int("010");
  ensure_equals("Convert BIT to integer", result, 10);

  result= myx_bit_to_int("0x");
  ensure_equals("Convert BIT to integer", result, 0);

  result= myx_bit_to_int("0xFFFF0000AAAA0000");
  ensure_equals("Convert BIT to integer", result, 18446462601596108800ULL);

}

//----------------------------------------------------------------------------------------------------------------------

TEST_FUNCTION(20)
{
  // Integer to BIT string conversion.
  // The conversion is based on baseconv from the utilities lib, which has been tested completely in the
  // util functions test module. Hence we only test what is added by myx_int_to_bit.
  char* result= myx_int_to_bit(0);
  ensure_equals("Convert integer to BIT", result, std::string("b'0'"));
  g_free(result);

  result= myx_int_to_bit(1020389);
  ensure_equals("Convert integer to BIT", result, std::string("b'11111001000111100101'"));
  g_free(result);
                                                                            
}

//----------------------------------------------------------------------------------------------------------------------

END_TESTS;
