unit AdminRestoreProgress;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, AuxFuncs, TntForms, TntStdCtrls, TntComCtrls,
  gnugettext, ExtCtrls;

type

  TRestoreOperation = (TR_ANALYZE, TR_RESTORE);

  TAdminRestoreProgressForm = class(TTntForm)
    ProgressGBox: TTntGroupBox;
    StopBtn: TTntButton;
    ProgressBar: TTntProgressBar;
    Lbl1: TTntLabel;
    TotalBytesLbl: TTntLabel;
    Lbl2: TTntLabel;
    ProcBytesLbl: TTntLabel;
    StatusLbl: TTntLabel;
    ProblemsMemo: TTntMemo;
    PLbl: TTntLabel;
    CloseButton: TTntButton;
    BackupFileLbl: TTntLabel;
    BackupFileCaptionLbl: TTntLabel;
    TntLabel1: TTntLabel;
    TntLabel2: TTntLabel;
    ElapsedTimeLabel: TTntLabel;
    RemainingTimeLabel: TTntLabel;
    Timer1: TTimer;
    constructor Create(AOwner: TComponent);  override;
    procedure StopBtnClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    firstTime: Boolean;
    problemsFound: Boolean;
    last_bytes_read: Int64;
    oStopBtn, oStoppingLbl, oHeight: Integer;
    FPercentDone: Single;
    FStartTime: TDateTime;
  protected
    procedure CreateParams(Var Params: TCreateParams); override;
  public
    Stopping: Boolean;
    procedure UpdateProgress(bytes_read: Int64; bytes_total: Int64);
    procedure AddWarning(msg: WideString);
    procedure UpdateForm(op: TRestoreOperation; SqlFilename: WideString);
    procedure OperationFinished(msg: WideString; Failed: Boolean);
    procedure ResetProgress;
  end;

//----------------------------------------------------------------------------------------------------------------------

implementation

const
  CDELTA= 110;

{$R *.dfm}

//----------------------------------------------------------------------------------------------------------------------

constructor TAdminRestoreProgressForm.Create(AOwner: TComponent);

begin
  inherited Create(AOwner);

  InitForm(self);
  ostopBtn:= stopBtn.top-CDELTA;
  oStoppingLbl:= StatusLbl.top-CDELTA;
  oHeight:= Height-CDELTA;

  resetProgress();
end;

procedure TAdminRestoreProgressForm.OperationFinished(msg: WideString; Failed: Boolean);

begin
  Timer1.Enabled := False;
  StopBtn.Visible:= false;
  CloseButton.Visible:= true;
  StatusLbl.Caption:= msg;
  if Failed then
    StatusLbl.Font.Color := clRed
  else
    StatusLbl.Font.Color := clBlack;
end;

procedure TAdminRestoreProgressForm.UpdateForm(op: TRestoreOperation;
                                               SqlFilename: WideString);
begin
  if(op = TR_ANALYZE) then
  begin
    Caption:= Format(_('Analyzing %s'), [SqlFileName]);

    ProgressGBox.Caption:=_('Analyzing');
    BackupFileLbl.Caption:= SqlFileName;
  end
  else
  begin
    Caption:= Format(_('Restoring %s'), [SqlFileName]);
    
    ProgressGBox.Caption:=_('Restoring');
    BackupFileLbl.Caption:= SqlFileName;
  end;

  ResetProgress();
end;

procedure TAdminRestoreProgressForm.UpdateProgress(bytes_read: Int64; bytes_total: Int64);

begin
  if firstTime then
  begin
    TotalBytesLbl.Caption:= intToStr(bytes_total);
    ProgressBar.Min:= 0;
    ProgressBar.Max:= 100;
    ProgressBar.Position:= 0;
    FStartTime := Now;
    firstTime:= false;
    Timer1.Enabled := True;
  end;

  FPercentDone := bytes_read / bytes_total;

  ProgressBar.Position := Round(100 * FPercentDone);
  ProcBytesLbl.Caption:= intToStr(bytes_read);

  Update;
end;

procedure TAdminRestoreProgressForm.ResetProgress();

begin
  Stopping:= false;
  firstTime:= true;
  last_bytes_read:= 0;
  ProblemsMemo.Clear;
  ProblemsFound:= false;
  stopbtn.Top:= oStopBtn;
  closebutton.Top:= oStopBtn;
  StatusLbl.Top:= oStoppingLbl;
  height:= oHeight;
  ProblemsMemo.Visible:= false;
  PLbl.Visible:= false;
  StopBtn.Visible:= true;
  CloseButton.Visible:= false;
  StatusLbl.Caption:= '';
  ElapsedTimeLabel.Caption := '00:00:00';
  RemainingTimeLabel.Caption := '00:00:00';
  FPercentDone := 0;
  Timer1.Enabled := False;
  ProgressBar.Position:= 0;

  Update;
end;

procedure TadminRestoreProgressForm.AddWarning(msg: WideString);
begin
  if (NOT problemsFound) then
  begin
    stopbtn.Top:= stopbtn.Top+CDELTA;
    closebutton.Top:= closebutton.Top + CDELTA;
    StatusLbl.Top:= StatusLbl.Top + CDELTA;
    height:= height + CDELTA;
    PLbl.Visible:= true;
    ProblemsMemo.Visible:= true;
    problemsFound:= true;
  end;

  ProblemsMemo.Lines.Add(msg);
end;


procedure TAdminRestoreProgressForm.StopBtnClick(Sender: TObject);
begin
  StatusLbl.Caption:= 'Stopping...';

  Stopping:=True;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminRestoreProgressForm.Timer1Timer(Sender: TObject);

var
  Elapsed: TDateTime;
  Hours: Word;
  Minutes: Word;
  Seconds: Word;
  Milliseconds: Word;
  ElapsedSeconds: Integer;
  RemainingSeconds: Integer;

begin
  Elapsed := Now - FStartTime;
  DecodeTime(Elapsed, Hours, Minutes, Seconds, Milliseconds);
  ElapsedTimeLabel.Caption := Format('%.2d:%.2d:%.2d', [Hours, Minutes, Seconds]);

  // Compute remaining time.
  if FPercentDone < 0.001 then
    RemainingTimeLabel.Caption := '??:??:??'
  else
  begin
    ElapsedSeconds := Seconds + 60 * Minutes + 3600 * Hours;
    RemainingSeconds := Round((1 - FPercentDone) * ElapsedSeconds / FPercentDone);
    Hours := RemainingSeconds div 3600;
    RemainingSeconds := RemainingSeconds - 3600 * Hours;
    Minutes := RemainingSeconds div 60;
    RemainingSeconds := RemainingSeconds - 60 * Minutes;
    Seconds := RemainingSeconds;
   RemainingTimeLabel.Caption := Format('%.2d:%.2d:%.2d', [Hours, Minutes, Seconds]);
  end;

  Update;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminRestoreProgressForm.CloseButtonClick(Sender: TObject);

begin
  close;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminRestoreProgressForm.CreateParams(var Params: TCreateParams);

begin
  Inherited CreateParams(Params);

  Params.exStyle:=Params.exStyle or WS_EX_APPWINDOW;
end;

//----------------------------------------------------------------------------------------------------------------------

end.
