/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MGIMAGECHECKBUTTON_H_
#define _MGIMAGECHECKBUTTON_H_

#include <gtkmm/eventbox.h>
#include <gdkmm/pixbuf.h>

class MGImageCheckButton : public Gtk::EventBox {
  public:
    bool _state;
    
    sigc::signal0<void> _signal_toggled;

  private:
    Glib::RefPtr<Gdk::Pixbuf> _on_img;
    Glib::RefPtr<Gdk::Pixbuf> _off_img;
    
    
    bool on_expose(GdkEventExpose *ev);
    bool on_button_press(GdkEventButton *ev);

  public:
    MGImageCheckButton(const Glib::RefPtr<Gdk::Pixbuf> &on_img,
                       const Glib::RefPtr<Gdk::Pixbuf> &off_img);

    void set_active(bool state);
    bool get_active() { return _state; };
    void toggled();
    
    sigc::signal0<void> signal_toggled() { return _signal_toggled; };
};


#endif /* _MGIMAGECHECKBUTTON_H_ */
