unit AdminRestoreProgress;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, AuxFuncs, TntForms, TntStdCtrls, TntComCtrls,
  gnugettext;

type

  TRestoreOperation = (TR_ANALYZE, TR_RESTORE);

  TAdminRestoreProgressForm = class(TTntForm)
    ProgressGBox: TTntGroupBox;
    StopBtn: TTntButton;
    ProgressBar: TTntProgressBar;
    Lbl1: TTntLabel;
    TotalBytesLbl: TTntLabel;
    Lbl2: TTntLabel;
    ProcBytesLbl: TTntLabel;
    StatusLbl: TTntLabel;
    ProblemsMemo: TTntMemo;
    PLbl: TTntLabel;
    CloseButton: TTntButton;
    BackupFileLbl: TTntLabel;
    BackupFileCaptionLbl: TTntLabel;
    constructor Create(AOwner: TComponent);  override;
    procedure StopBtnClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
  private
    firstTime: Boolean;
    problemsFound: Boolean;
    last_bytes_read: Int64;
    oStopBtn, oStoppingLbl, oHeight: Integer;
    procedure ResetProgress();
  protected
    procedure CreateParams(Var Params: TCreateParams); override;
  public
    Stopping: Boolean;
    procedure UpdateProgress(bytes_read: Int64; bytes_total: Int64);
    procedure AddWarning(msg: WideString);
    procedure UpdateForm(op: TRestoreOperation; SqlFilename: WideString);
    procedure OperationFinished(msg: WideString; Failed: Boolean);
  end;

implementation
const
  CDELTA= 110;
  
{$R *.dfm}

constructor TAdminRestoreProgressForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  InitForm(self);
  ostopBtn:= stopBtn.top-CDELTA;
  oStoppingLbl:= StatusLbl.top-CDELTA;
  oHeight:= Height-CDELTA;

  resetProgress();
end;

procedure TAdminRestoreProgressForm.OperationFinished(msg: WideString; Failed: Boolean);

begin
  StopBtn.Visible:= false;
  CloseButton.Visible:= true;
  StatusLbl.Caption:= msg;
  if Failed then
    StatusLbl.Font.Color := clRed
  else
    StatusLbl.Font.Color := clBlack;
end;

procedure TAdminRestoreProgressForm.UpdateForm(op: TRestoreOperation;
                                               SqlFilename: WideString);
begin
  if(op = TR_ANALYZE) then
  begin
    Caption:= Format(_('Analyzing %s'), [SqlFileName]);

    ProgressGBox.Caption:=_('Analyzing');
    BackupFileLbl.Caption:= SqlFileName;
  end
  else
  begin
    Caption:= Format(_('Restoring %s'), [SqlFileName]);
    
    ProgressGBox.Caption:=_('Restoring');
    BackupFileLbl.Caption:= SqlFileName;
  end;

  ResetProgress();
end;

procedure TAdminRestoreProgressForm.UpdateProgress(bytes_read: Int64; bytes_total: Int64);
begin
  if (firstTime) then
  begin
    TotalBytesLbl.Caption:= intToStr(bytes_total);
    ProgressBar.Min:= 0;
    ProgressBar.Max:= bytes_total;
    ProgressBar.Position:= 0;
    firstTime:= false;
  end;

  ProcBytesLbl.Caption:= intToStr(bytes_read);
  ProgressBar.StepBy(bytes_read-last_bytes_read);
  last_bytes_read:= bytes_read;
end;

procedure TAdminRestoreProgressForm.ResetProgress();
begin
  Stopping:= false;
  firstTime:= true;
  last_bytes_read:= 0;
  ProblemsMemo.Clear;
  ProblemsFound:= false;
  stopbtn.Top:= oStopBtn;
  closebutton.Top:= oStopBtn;
  StatusLbl.Top:= oStoppingLbl;
  height:= oHeight;
  ProblemsMemo.Visible:= false;
  PLbl.Visible:= false;
  StopBtn.Visible:= true;
  CloseButton.Visible:= false;
  StatusLbl.Caption:= '';
end;

procedure TadminRestoreProgressForm.AddWarning(msg: WideString);
begin
  if (NOT problemsFound) then
  begin
    stopbtn.Top:= stopbtn.Top+CDELTA;
    closebutton.Top:= closebutton.Top + CDELTA;
    StatusLbl.Top:= StatusLbl.Top + CDELTA;
    height:= height + CDELTA;
    PLbl.Visible:= true;
    ProblemsMemo.Visible:= true;
    problemsFound:= true;
  end;

  ProblemsMemo.Lines.Add(msg);
end;


procedure TAdminRestoreProgressForm.StopBtnClick(Sender: TObject);
begin
  StatusLbl.Caption:= 'Stopping...';

  Stopping:=True;
end;

procedure TAdminRestoreProgressForm.CloseButtonClick(Sender: TObject);
begin
  close;
end;

procedure TAdminRestoreProgressForm.CreateParams(var Params: TCreateParams);
begin
  Inherited CreateParams(Params);

  Params.exStyle:=Params.exStyle or WS_EX_APPWINDOW;
end;


end.
