/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;

class SQLParser {
    private char[] in;
    private int s;
    private int len;
    private char[] out;
    private int d;
    private ArrayList params;
    private char terminator;
    private String procName;
    private String keyWord;
    private String tableName;
    private ConnectionJDBC2 connection;
    private static final byte[] timeMask = new byte[]{35, 35, 58, 35, 35, 58, 35, 35};
    private static final byte[] dateMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35};
    static final byte[] timestampMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35, 32, 35, 35, 58, 35, 35, 58, 35, 35};
    private static HashMap fnMap = new HashMap();
    private static HashMap msFnMap = new HashMap();
    private static HashMap cvMap = new HashMap();

    SQLParser(String sql, ArrayList paramList, ConnectionJDBC2 connection) {
        this.in = sql.toCharArray();
        this.len = this.in.length;
        this.out = new char[this.len + 256];
        this.s = 0;
        this.d = 0;
        this.params = paramList;
        this.procName = "";
        this.connection = connection;
    }

    private void copyLiteral(String txt) {
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (c == '?') {
                ParamInfo pi = new ParamInfo(this.d);
                this.params.add(pi);
            }
            this.out[this.d++] = c;
            ++i;
        }
    }

    private void copyString() {
        char saveTc = this.terminator;
        char tc = this.in[this.s];
        if (tc == '[') {
            tc = ']';
        }
        this.terminator = tc;
        do {
            this.out[this.d++] = this.in[this.s++];
            while (this.in[this.s] != tc) {
                this.out[this.d++] = this.in[this.s++];
            }
            this.out[this.d++] = this.in[this.s++];
        } while (this.s < this.len && this.in[this.s] == tc);
        this.terminator = saveTc;
    }

    private String copyKeyWord() {
        int start = this.d;
        while (this.s < this.len && Character.isJavaIdentifierPart(this.in[this.s])) {
            this.out[this.d++] = this.in[this.s++];
        }
        return String.valueOf(this.out, start, this.d - start).toLowerCase();
    }

    private void copyParam(String name, int pos) {
        ParamInfo pi = new ParamInfo(pos);
        pi.name = name;
        if (pos >= 0) {
            this.out[this.d++] = this.in[this.s++];
        } else {
            pi.isRetVal = true;
            ++this.s;
        }
        this.params.add(pi);
    }

    private String copyProcName() throws SQLException {
        int start = this.d;
        block0: while (true) {
            if (this.in[this.s] == '\"' || this.in[this.s] == '[') {
                this.copyString();
            } else {
                char c = this.in[this.s++];
                while (Character.isJavaIdentifierPart(c) || c == '#' || c == ';') {
                    this.out[this.d++] = c;
                    c = this.in[this.s++];
                }
                --this.s;
            }
            if (this.in[this.s] != '.') break;
            while (true) {
                if (this.in[this.s] != '.') continue block0;
                this.out[this.d++] = this.in[this.s++];
            }
            break;
        }
        if (this.d == start) {
            throw new SQLException(Messages.get("error.parsesql.syntax", "call", String.valueOf(this.s)), "22025");
        }
        return new String(this.out, start, this.d - start);
    }

    private String copyParamName() {
        int start = this.d;
        char c = this.in[this.s++];
        while (Character.isJavaIdentifierPart(c) || c == '@') {
            this.out[this.d++] = c;
            c = this.in[this.s++];
        }
        --this.s;
        return new String(this.out, start, this.d - start);
    }

    private void mustbe(char c, boolean copy) throws SQLException {
        if (this.in[this.s] != c) {
            throw new SQLException(Messages.get("error.parsesql.mustbe", String.valueOf(this.s), String.valueOf(c)), "22019");
        }
        if (copy) {
            this.out[this.d++] = this.in[this.s++];
        } else {
            ++this.s;
        }
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.in[this.s])) {
            ++this.s;
        }
    }

    private void skipSingleComments() {
        while (this.s < this.len && this.in[this.s] != '\n' && this.in[this.s] != '\r') {
            this.out[this.d++] = this.in[this.s++];
        }
    }

    private void skipMultiComments() {
        int block = 0;
        do {
            if (this.s >= this.len - 1) continue;
            if (this.in[this.s] == '/' && this.in[this.s + 1] == '*') {
                ++block;
            } else if (this.in[this.s] == '*' && this.in[this.s + 1] == '/') {
                --block;
            }
            this.out[this.d++] = this.in[this.s++];
        } while (block > 0);
    }

    private void callEscape() throws SQLException {
        this.copyLiteral("EXECUTE ");
        this.keyWord = "execute";
        this.procName = this.copyProcName();
        this.skipWhiteSpace();
        if (this.in[this.s] == '(') {
            ++this.s;
            this.skipWhiteSpace();
            this.terminator = (char)41;
        } else {
            this.terminator = (char)125;
        }
        this.out[this.d++] = 32;
        while (this.in[this.s] != this.terminator) {
            String name = null;
            if (this.in[this.s] == '@') {
                name = this.copyParamName();
                this.skipWhiteSpace();
                this.mustbe('=', true);
                this.skipWhiteSpace();
                if (this.in[this.s] == '?') {
                    this.copyParam(name, this.d);
                } else {
                    this.procName = "";
                }
            } else if (this.in[this.s] == '?') {
                this.copyParam(name, this.d);
            } else {
                this.procName = "";
            }
            while (this.in[this.s] != this.terminator && this.in[this.s] != ',') {
                if (this.in[this.s] == '{') {
                    this.escape();
                    continue;
                }
                if (this.in[this.s] == '\'' || this.in[this.s] == '[' || this.in[this.s] == '\"') {
                    this.copyString();
                    continue;
                }
                this.out[this.d++] = this.in[this.s++];
            }
            if (this.in[this.s] == ',') {
                this.out[this.d++] = this.in[this.s++];
            }
            this.skipWhiteSpace();
        }
        if (this.terminator == ')') {
            ++this.s;
        }
        this.skipWhiteSpace();
        this.terminator = (char)125;
    }

    private boolean getDateTimeField(byte[] mask) {
        this.skipWhiteSpace();
        if (this.in[this.s] == '?') {
            this.copyParam(null, this.d);
            this.skipWhiteSpace();
            return this.in[this.s] == this.terminator;
        }
        this.out[this.d++] = 39;
        this.terminator = (char)(this.in[this.s] == '\'' || this.in[this.s] == '\"' ? this.in[this.s++] : 125);
        this.skipWhiteSpace();
        int ptr = 0;
        while (ptr < mask.length) {
            char c;
            if ((c = this.in[this.s++]) == ' ' && this.out[this.d - 1] == ' ') continue;
            if (mask[ptr] == 35 ? !Character.isDigit(c) : mask[ptr] != c) {
                return false;
            }
            if (c != '-') {
                this.out[this.d++] = c;
            }
            ++ptr;
        }
        if (mask.length == 19) {
            int digits = 0;
            if (this.in[this.s] == '.') {
                this.out[this.d++] = this.in[this.s++];
                while (Character.isDigit(this.in[this.s])) {
                    if (digits < 3) {
                        this.out[this.d++] = this.in[this.s++];
                        ++digits;
                        continue;
                    }
                    ++this.s;
                }
            } else {
                this.out[this.d++] = 46;
            }
            while (digits < 3) {
                this.out[this.d++] = 48;
                ++digits;
            }
        }
        this.skipWhiteSpace();
        if (this.in[this.s] != this.terminator) {
            return false;
        }
        if (this.terminator != '}') {
            ++this.s;
        }
        this.skipWhiteSpace();
        this.out[this.d++] = 39;
        return true;
    }

    private void timeEscape() throws SQLException {
        if (!this.getDateTimeField(timeMask)) {
            throw new SQLException(Messages.get("error.parsesql.syntax", "time", String.valueOf(this.s)), "22019");
        }
    }

    private void dateEscape() throws SQLException {
        if (!this.getDateTimeField(dateMask)) {
            throw new SQLException(Messages.get("error.parsesql.syntax", "date", String.valueOf(this.s)), "22019");
        }
    }

    private void timestampEscape() throws SQLException {
        if (!this.getDateTimeField(timestampMask)) {
            throw new SQLException(Messages.get("error.parsesql.syntax", "timestamp", String.valueOf(this.s)), "22019");
        }
    }

    private void outerJoinEscape() throws SQLException {
        while (this.in[this.s] != '}') {
            char c = this.in[this.s];
            switch (c) {
                case '\"': 
                case '\'': 
                case '[': {
                    this.copyString();
                    break;
                }
                case '{': {
                    this.escape();
                    break;
                }
                case '?': {
                    this.copyParam(null, this.d);
                    break;
                }
                default: {
                    this.out[this.d++] = c;
                    ++this.s;
                }
            }
        }
    }

    private void functionEscape() throws SQLException {
        String fn;
        char tc = this.terminator;
        this.skipWhiteSpace();
        StringBuffer nameBuf = new StringBuffer();
        while (Character.isLetterOrDigit(this.in[this.s])) {
            nameBuf.append(this.in[this.s++]);
        }
        String name = nameBuf.toString().toLowerCase();
        this.skipWhiteSpace();
        this.mustbe('(', false);
        int parenCnt = 1;
        int argStart = this.d;
        int arg2Start = 0;
        this.terminator = (char)41;
        while (this.in[this.s] != ')' || parenCnt > 1) {
            char c = this.in[this.s];
            switch (c) {
                case '\"': 
                case '\'': 
                case '[': {
                    this.copyString();
                    break;
                }
                case '{': {
                    this.escape();
                    break;
                }
                case ',': {
                    if (arg2Start == 0) {
                        arg2Start = this.d - argStart;
                    }
                    if (name.equals("concat")) {
                        this.out[this.d++] = 43;
                        ++this.s;
                        break;
                    }
                    if (name.equals("mod")) {
                        this.out[this.d++] = 37;
                        ++this.s;
                        break;
                    }
                    this.out[this.d++] = c;
                    ++this.s;
                    break;
                }
                case '(': {
                    ++parenCnt;
                    this.out[this.d++] = c;
                    ++this.s;
                    break;
                }
                case ')': {
                    --parenCnt;
                    this.out[this.d++] = c;
                    ++this.s;
                    break;
                }
                default: {
                    this.out[this.d++] = c;
                    ++this.s;
                }
            }
        }
        String args = String.valueOf(this.out, argStart, this.d - argStart).trim();
        this.d = argStart;
        this.mustbe(')', false);
        this.terminator = tc;
        this.skipWhiteSpace();
        if (name.equals("convert") && arg2Start < args.length() - 1) {
            String arg2 = args.substring(arg2Start + 1).trim().toLowerCase();
            String dataType = (String)cvMap.get(arg2);
            if (dataType == null) {
                dataType = arg2;
            }
            this.copyLiteral("convert(");
            this.copyLiteral(dataType);
            this.out[this.d++] = 44;
            this.copyLiteral(args.substring(0, arg2Start));
            this.out[this.d++] = 41;
            return;
        }
        if (this.connection.getServerType() == 1) {
            fn = (String)msFnMap.get(name);
            if (fn == null) {
                fn = (String)fnMap.get(name);
            }
        } else {
            fn = (String)fnMap.get(name);
        }
        if (fn == null) {
            this.copyLiteral(name);
            this.out[this.d++] = 40;
            this.copyLiteral(args);
            this.out[this.d++] = 41;
            return;
        }
        if (args.length() > 8 && args.substring(0, 8).equalsIgnoreCase("sql_tsi_") && (args = args.substring(8)).length() > 11 && args.substring(0, 11).equalsIgnoreCase("frac_second")) {
            args = "millisecond" + args.substring(11);
        }
        int i = 0;
        while (i < fn.length()) {
            char c = fn.charAt(i);
            if (c == '$') {
                this.copyLiteral(args);
            } else {
                this.out[this.d++] = c;
            }
            ++i;
        }
    }

    private void likeEscape() throws SQLException {
        this.copyLiteral("escape ");
        this.skipWhiteSpace();
        if (this.in[this.s] == '\'' || this.in[this.s] == '\"') {
            this.copyString();
        } else {
            this.mustbe('\'', true);
        }
        this.skipWhiteSpace();
    }

    /*
     * Unable to fully structure code
     */
    private void escape() throws SQLException {
        tc = this.terminator;
        this.terminator = (char)125;
        escBuf = new StringBuffer();
        ++this.s;
        this.skipWhiteSpace();
        if (this.in[this.s] != '?') ** GOTO lbl23
        this.copyParam("@return_status", -1);
        this.skipWhiteSpace();
        this.mustbe('=', false);
        this.skipWhiteSpace();
        while (Character.isLetter(this.in[this.s])) {
            escBuf.append(this.in[this.s++]);
        }
        this.skipWhiteSpace();
        esc = escBuf.toString();
        if (esc.equalsIgnoreCase("call")) {
            this.callEscape();
        } else {
            throw new SQLException(Messages.get("error.parsesql.syntax", "call", String.valueOf(this.s)), "22019");
lbl-1000:
            // 1 sources

            {
                escBuf.append(this.in[this.s++]);
lbl23:
                // 2 sources

                ** while (Character.isLetter((char)this.in[this.s]))
            }
lbl24:
            // 1 sources

            this.skipWhiteSpace();
            esc = escBuf.toString();
            if (esc.equalsIgnoreCase("call")) {
                this.callEscape();
            } else if (esc.equalsIgnoreCase("t")) {
                this.timeEscape();
            } else if (esc.equalsIgnoreCase("d")) {
                this.dateEscape();
            } else if (esc.equalsIgnoreCase("ts")) {
                this.timestampEscape();
            } else if (esc.equalsIgnoreCase("oj")) {
                this.outerJoinEscape();
            } else if (esc.equalsIgnoreCase("fn")) {
                this.functionEscape();
            } else if (esc.equalsIgnoreCase("escape")) {
                this.likeEscape();
            } else {
                throw new SQLException(Messages.get("error.parsesql.badesc", esc, String.valueOf(this.s)), "22019");
            }
        }
        this.mustbe('}', false);
        this.terminator = tc;
    }

    /*
     * Unable to fully structure code
     */
    private String getTableName() {
        name = new StringBuffer(128);
        c = this.s < this.len ? this.in[this.s] : 32;
        while (this.s < this.len && Character.isWhitespace((char)c)) {
            this.out[this.d++] = c;
            ++this.s;
            v0 = c = this.s < this.len ? this.in[this.s] : 32;
        }
        if (c != 123) ** GOTO lbl23
        return "";
lbl-1000:
        // 1 sources

        {
            if (c == 47) {
                if (this.s + 1 >= this.len || this.in[this.s + 1] != '*') break;
                this.skipMultiComments();
                ++this.s;
            } else {
                if (this.s + 1 >= this.len || this.in[this.s + 1] != '-') break;
                this.skipSingleComments();
            }
            c = this.s < this.len ? this.in[this.s] : 32;
            while (this.s < this.len && Character.isWhitespace((char)c)) {
                this.out[this.d++] = c;
                ++this.s;
                v1 = c = this.s < this.len ? this.in[this.s] : 32;
            }
lbl23:
            // 2 sources

            ** while (c == 47 || c == 45)
        }
lbl24:
        // 3 sources

        if (c != 123) ** GOTO lbl57
        return "";
lbl-1000:
        // 1 sources

        {
            if (c == 91 || c == 34) {
                start = this.d;
                this.copyString();
                name.append(String.valueOf(this.out, start, this.d - start));
                c = this.s < this.len ? this.in[this.s] : 32;
            } else {
                start = this.d;
                while (this.s < this.len && !Character.isWhitespace((char)c) && c != 46 && c != 44) {
                    this.out[this.d++] = c;
                    ++this.s;
                    v2 = c = this.s < this.len ? this.in[this.s] : 32;
                }
                name.append(String.valueOf(this.out, start, this.d - start));
            }
            while (this.s < this.len && Character.isWhitespace((char)c)) {
                this.out[this.d++] = c;
                ++this.s;
                v3 = c = this.s < this.len ? this.in[this.s] : 32;
            }
            if (c != 46) break;
            name.append((char)c);
            this.out[this.d++] = c;
            ++this.s;
            c = this.s < this.len ? this.in[this.s] : 32;
            while (this.s < this.len && Character.isWhitespace((char)c)) {
                this.out[this.d++] = c;
                ++this.s;
                v4 = c = this.s < this.len ? this.in[this.s] : 32;
            }
lbl57:
            // 2 sources

            ** while (this.s < this.len)
        }
lbl58:
        // 2 sources

        return name.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] parse(boolean extractTable) throws SQLException {
        isSelect = false;
        try {
            block21: {
                block22: {
                    while (true) lbl-1000:
                    // 13 sources

                    {
                        if (this.s >= this.len) {
                            if (this.params.size() <= 255) break block21;
                            limit = 255;
                            if (this.connection.getServerType() != 2) break;
                            if (this.connection.getDatabaseMajorVersion() > 12 || this.connection.getDatabaseMajorVersion() == 12 && this.connection.getDatabaseMinorVersion() >= 50) {
                                limit = 2000;
                            }
                            break block22;
                        }
                        c = this.in[this.s];
                        switch (c) {
                            case '{': {
                                this.escape();
                                ** break;
                            }
                            case '\"': 
                            case '\'': 
                            case '[': {
                                this.copyString();
                                ** break;
                            }
                            case '?': {
                                this.copyParam(null, this.d);
                                ** break;
                            }
                            case '/': {
                                if (this.s + 1 < this.len && this.in[this.s + 1] == '*') {
                                    this.skipMultiComments();
                                    ** break;
                                }
                                this.out[this.d++] = c;
                                ++this.s;
                                ** break;
                            }
                            case '-': {
                                if (this.s + 1 < this.len && this.in[this.s + 1] == '-') {
                                    this.skipSingleComments();
                                    ** break;
                                }
                                this.out[this.d++] = c;
                                ++this.s;
                                ** break;
                            }
                        }
                        if (Character.isLetter(c)) {
                            if (this.keyWord == null) {
                                this.keyWord = this.copyKeyWord();
                                if (!this.keyWord.equals("select")) continue;
                                isSelect = true;
                                ** break;
                            }
                            if (extractTable && isSelect) {
                                sqlWord = this.copyKeyWord();
                                if (!sqlWord.equals("from")) continue;
                                extractTable = false;
                                this.tableName = this.getTableName();
                                ** break;
                            }
                        }
                        this.out[this.d++] = c;
                        ++this.s;
                    }
                    if (this.connection.getDatabaseMajorVersion() == 7) {
                        limit = 1000;
                    } else if (this.connection.getDatabaseMajorVersion() > 7) {
                        limit = 2000;
                    }
                }
                if (this.params.size() > limit) {
                    throw new SQLException(Messages.get("error.parsesql.toomanyparams", Integer.toString(limit)), "22025");
                }
            }
            result = new String[]{new String(this.out, 0, this.d), this.procName, this.keyWord == null ? "" : this.keyWord, this.tableName};
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(Messages.get("error.parsesql.missing", String.valueOf(this.terminator)), "22025");
        }
    }

    static {
        msFnMap.put("length", "len($)");
        msFnMap.put("truncate", "round($, 1)");
        fnMap.put("user", "user_name($)");
        fnMap.put("database", "db_name($)");
        fnMap.put("ifnull", "isnull($)");
        fnMap.put("now", "getdate($)");
        fnMap.put("atan2", "atn2($)");
        fnMap.put("mod", "($)");
        fnMap.put("length", "char_length($)");
        fnMap.put("locate", "charindex($)");
        fnMap.put("repeat", "replicate($)");
        fnMap.put("insert", "stuff($)");
        fnMap.put("lcase", "lower($)");
        fnMap.put("ucase", "upper($)");
        fnMap.put("concat", "($)");
        fnMap.put("curdate", "convert(datetime, convert(varchar, getdate(), 112))");
        fnMap.put("curtime", "convert(datetime, convert(varchar, getdate(), 108))");
        fnMap.put("dayname", "datename(weekday,$)");
        fnMap.put("dayofmonth", "datepart(day,$)");
        fnMap.put("dayofweek", "datepart(weekday,$)");
        fnMap.put("dayofyear", "datepart(dayofyear,$)");
        fnMap.put("hour", "datepart(hour,$)");
        fnMap.put("minute", "datepart(minute,$)");
        fnMap.put("second", "datepart(second,$)");
        fnMap.put("year", "datepart(year,$)");
        fnMap.put("quarter", "datepart(quarter,$)");
        fnMap.put("month", "datepart(month,$)");
        fnMap.put("week", "datepart(week,$)");
        fnMap.put("monthname", "datename(month,$)");
        fnMap.put("timestampadd", "dateadd($)");
        fnMap.put("timestampdiff", "datediff($)");
        cvMap.put("binary", "varbinary");
        cvMap.put("char", "varchar");
        cvMap.put("date", "datetime");
        cvMap.put("double", "float");
        cvMap.put("longvarbinary", "image");
        cvMap.put("longvarchar", "text");
        cvMap.put("time", "datetime");
        cvMap.put("timestamp", "timestamp");
    }
}

