/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.TdsCore;
import net.sourceforge.jtds.jdbc.TextPtr;

public class JtdsReader
extends Reader {
    private TdsCore tds;
    private int length;
    private int offset = 0;
    private String colName;
    private String tabName;
    private TextPtr textPtr;
    private static final int BUFSIZE = 4096;
    private char[] buffer = null;
    private int pos = 0;
    private String charset;

    JtdsReader(ConnectionJDBC2 con, ColInfo ci, TextPtr textPtr, String charset) throws SQLException {
        this.tds = new TdsCore(con, new SQLDiagnostic(con.getServerType()));
        this.colName = ci.realName;
        this.tabName = ci.tableName;
        this.textPtr = textPtr;
        this.length = this.tds.dataLength(this.tabName, this.colName);
        if (ci.sqlType.equalsIgnoreCase("ntext")) {
            this.length /= 2;
        }
        this.charset = charset;
        this.fillBuffer();
    }

    int available() {
        return this.length - this.offset;
    }

    int getLength() {
        return this.length;
    }

    public void reset() throws IOException {
        this.offset = 0;
        this.pos = 0;
        this.buffer = null;
        try {
            this.fillBuffer();
        }
        catch (SQLException e) {
            throw new IOException("SQL Error: " + e.getMessage());
        }
    }

    void fillBuffer() throws SQLException {
        int bc = 4096;
        this.pos = 0;
        if (this.offset + bc > this.length && (bc = this.length - this.offset) == 0) {
            this.buffer = new char[0];
            return;
        }
        Object result = this.tds.readText(this.tabName, this.colName, this.textPtr, this.offset, bc);
        if (result instanceof byte[]) {
            try {
                this.buffer = new String((byte[])result, this.charset).toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                this.buffer = new String((byte[])result).toCharArray();
            }
            this.offset += ((byte[])result).length;
        } else if (result instanceof char[]) {
            this.buffer = (char[])result;
            this.offset += this.buffer.length;
        }
    }

    public int read() throws IOException {
        if (this.pos == this.buffer.length) {
            if (this.tds == null) {
                throw new IOException("InputStream is closed");
            }
            try {
                this.fillBuffer();
            }
            catch (SQLException e) {
                throw new IOException("SQL Error: " + e.getMessage());
            }
            if (this.buffer.length == 0) {
                return -1;
            }
        }
        return this.buffer[this.pos++];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            try {
                this.tds.close();
            }
            catch (SQLException e) {
                Object var3_2 = null;
                this.tds = null;
                this.buffer = new char[0];
                return;
            }
            Object var3_1 = null;
            this.tds = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.tds = null;
            this.buffer = new char[0];
            throw throwable;
        }
        this.buffer = new char[0];
    }

    public int read(char[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int b = this.read();
        if (b < 0) {
            return -1;
        }
        buf[off] = (char)b;
        int i = 1;
        while (i < len) {
            b = this.read();
            if (b < 0) {
                return i;
            }
            buf[off + i] = (char)b;
            ++i;
        }
        return i;
    }
}

