/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashSet;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.SQLParser;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsCore;

public class CachedResultSet
extends JtdsResultSet {
    protected ArrayList rowData;
    protected static final int INITIAL_ROW_COUNT = 1000;
    protected boolean onInsertRow;
    protected ParamInfo[] insertRow;
    protected ParamInfo[] updateRow;
    protected boolean hasKeys;
    protected boolean rowUpdated = false;
    protected boolean rowDeleted = false;
    protected int initialRowCnt;
    protected boolean tempResultSet = false;
    protected TdsCore cursorTds;
    protected TdsCore updateTds;
    protected boolean isSybase;
    protected boolean sizeChanged = false;
    protected String sql;
    protected String procName;
    protected ParamInfo[] procedureParams;
    protected boolean isKeyed;
    protected String tableName;

    CachedResultSet(JtdsStatement statement, String sql, String procName, ParamInfo[] procedureParams, int resultSetType, int concurrency) throws SQLException {
        super(statement, resultSetType, concurrency, null, false);
        this.cursorTds = statement.getTds();
        this.sql = sql;
        this.procName = procName;
        this.procedureParams = procedureParams;
        this.updateTds = this.cursorTds;
        if (resultSetType == 1003 && this.cursorName != null && concurrency == 1008) {
            this.updateTds = new TdsCore((ConnectionJDBC2)statement.getConnection(), statement.getMessages());
        }
        this.isSybase = 2 == ((ConnectionJDBC2)statement.getConnection()).getServerType();
        this.cursorCreate(sql, procName, procedureParams);
    }

    CachedResultSet(JtdsStatement statement, String[] colName, int[] colType) throws SQLException {
        super(statement, 1003, 1008, null, false);
        this.columns = new ColInfo[colName.length];
        int i = 0;
        while (i < colName.length) {
            ColInfo ci = new ColInfo();
            ci.name = colName[i];
            ci.realName = colName[i];
            ci.jdbcType = colType[i];
            switch (ci.jdbcType) {
                case 12: {
                    ci.sqlType = "varchar";
                    break;
                }
                case 4: {
                    ci.sqlType = "int";
                    break;
                }
                case 5: {
                    ci.sqlType = "smallint";
                    break;
                }
                case -7: {
                    ci.sqlType = "bit";
                }
            }
            this.columns[i] = ci;
            ++i;
        }
        this.columnCount = this.getColumnCount(this.columns);
        this.rowData = new ArrayList(1000);
        this.rowsInResult = 0;
        this.initialRowCnt = 0;
        this.pos = 0;
        this.tempResultSet = true;
        this.cursorName = null;
    }

    CachedResultSet(JtdsResultSet rs) throws SQLException {
        super((JtdsStatement)rs.getStatement(), 1003, 1008, null, false);
        this.columns = rs.getColumns();
        this.columnCount = this.getColumnCount(this.columns);
        this.rowData = new ArrayList(1000);
        this.rowsInResult = 0;
        this.initialRowCnt = 0;
        this.pos = 0;
        this.tempResultSet = true;
        this.cursorName = null;
    }

    CachedResultSet(JtdsStatement statement, ColInfo[] columns, Object[] data) throws SQLException {
        super(statement, 1003, 1007, null, false);
        this.columns = columns;
        this.columnCount = this.getColumnCount(columns);
        this.rowData = new ArrayList(1);
        this.rowsInResult = 1;
        this.initialRowCnt = 1;
        this.pos = 0;
        this.tempResultSet = true;
        this.cursorName = null;
        this.rowData.add(this.copyRow(data));
    }

    void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    private void cursorCreate(String sql, String procName, ParamInfo[] parameters) throws SQLException {
        boolean isSelect = false;
        SQLWarning warning = null;
        if (this.resultSetType != 1003 || this.concurrency == 1008 || this.cursorName != null) {
            ArrayList params = new ArrayList();
            String[] tmp = new SQLParser(sql, params, (ConnectionJDBC2)this.statement.getConnection()).parse(true);
            if (tmp[2].equals("select") && tmp[3] != null && tmp[3].length() > 0) {
                this.tableName = tmp[3];
                isSelect = true;
            } else {
                this.cursorName = null;
                if (this.concurrency == 1008) {
                    this.concurrency = 1007;
                    warning = new SQLWarning(Messages.get("warning.cursordowngraded", "CONCUR_READ_ONLY"), "01000");
                }
                if (this.resultSetType == 1005) {
                    this.resultSetType = 1004;
                    SQLWarning warning2 = new SQLWarning(Messages.get("warning.cursordowngraded", "TYPE_SCROLL_INSENSITIVE"), "01000");
                    if (warning != null) {
                        warning.setNextWarning(warning2);
                    } else {
                        warning = warning2;
                    }
                }
            }
        }
        if (this.cursorName != null) {
            if (parameters != null && parameters.length > 0) {
                sql = Support.substituteParameters(sql, parameters, this.statement.getTds().getTdsVersion());
            }
            StringBuffer cursorSQL = new StringBuffer(sql.length() + this.cursorName.length() + 128);
            cursorSQL.append("DECLARE ").append(this.cursorName).append(" CURSOR FOR ").append(sql);
            this.cursorTds.executeSQL(cursorSQL.toString(), procName, parameters, false, this.statement.getQueryTimeout(), this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
            this.cursorTds.clearResponseQueue();
            cursorSQL.setLength(0);
            cursorSQL.append("\r\nOPEN ").append(this.cursorName);
            if (this.fetchSize > 1 && this.isSybase) {
                cursorSQL.append("\r\nSET CURSOR ROWS ").append(this.fetchSize);
                cursorSQL.append(" FOR ").append(this.cursorName);
            }
            cursorSQL.append("\r\nFETCH ").append(this.cursorName);
            this.cursorTds.executeSQL(cursorSQL.toString(), null, null, false, this.statement.getQueryTimeout(), this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
            while (!this.cursorTds.getMoreResults() && !this.cursorTds.isEndOfResponse()) {
            }
            if (!this.cursorTds.isResultSet()) {
                throw new SQLException(Messages.get("error.statement.noresult"), "24000");
            }
            this.columns = this.cursorTds.getColumns();
            this.columnCount = this.getColumnCount(this.columns);
        } else {
            if (isSelect && (this.concurrency == 1008 || this.resultSetType != 1003)) {
                this.cursorTds.executeSQL(sql + " FOR BROWSE", null, parameters, false, this.statement.getQueryTimeout(), this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
                while (!this.cursorTds.getMoreResults() && !this.cursorTds.isEndOfResponse()) {
                }
                if (!this.cursorTds.isResultSet()) {
                    throw new SQLException(Messages.get("error.statement.noresult"), "24000");
                }
                this.columns = this.cursorTds.getColumns();
                this.columnCount = this.getColumnCount(this.columns);
                this.rowData = new ArrayList(1000);
                while (super.next()) {
                    this.rowData.add(this.copyRow(this.currentRow));
                }
                this.initialRowCnt = this.rowsInResult = this.rowData.size();
                this.pos = 0;
                if (!this.isCursorUpdateable()) {
                    if (this.concurrency == 1008) {
                        this.concurrency = 1007;
                        this.statement.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", "CONCUR_READ_ONLY"), "01000"));
                    }
                    if (this.resultSetType == 1005) {
                        this.resultSetType = 1004;
                        this.statement.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", "TYPE_SCROLL_INSENSITIVE"), "01000"));
                    }
                }
                return;
            }
            this.cursorTds.executeSQL(sql, procName, parameters, false, this.statement.getQueryTimeout(), this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
            while (!this.cursorTds.getMoreResults() && !this.cursorTds.isEndOfResponse()) {
            }
            if (!this.cursorTds.isResultSet()) {
                throw new SQLException(Messages.get("error.statement.noresult"), "24000");
            }
            this.columns = this.cursorTds.getColumns();
            this.columnCount = this.getColumnCount(this.columns);
            this.rowData = new ArrayList(1000);
            while (super.next()) {
                this.rowData.add(this.copyRow(this.currentRow));
            }
            this.initialRowCnt = this.rowsInResult = this.rowData.size();
            this.pos = 0;
            if (warning != null) {
                this.statement.addWarning(warning);
            }
        }
    }

    boolean isCursorUpdateable() throws SQLException {
        this.isKeyed = false;
        HashSet<String> tableSet = new HashSet<String>();
        int i = 0;
        while (i < this.columns.length) {
            ColInfo ci = this.columns[i];
            if (ci.isKey) {
                if (ci.sqlType.equals("text") || ci.sqlType.equals("image")) {
                    ci.isKey = false;
                } else {
                    this.isKeyed = true;
                }
            } else if (ci.isIdentity) {
                ci.isKey = true;
                this.isKeyed = true;
            }
            if (ci.tableName != null && ci.tableName.length() > 0) {
                StringBuffer key = new StringBuffer();
                if (ci.catalog != null) {
                    key.append(ci.catalog).append('.');
                    if (ci.schema == null) {
                        key.append('.');
                    }
                }
                if (ci.schema != null) {
                    key.append(ci.schema).append('.');
                }
                key.append(ci.tableName);
                this.tableName = key.toString();
                tableSet.add(this.tableName);
            }
            ++i;
        }
        if (this.tableName.startsWith("#") && this.cursorTds.getTdsVersion() >= 3) {
            StringBuffer sql = new StringBuffer(1024);
            sql.append("SELECT ");
            int i2 = 1;
            while (i2 <= 8) {
                if (i2 > 1) {
                    sql.append(",");
                }
                sql.append("index_col('tempdb..").append(this.tableName);
                sql.append("', indid, ").append(i2).append(")");
                ++i2;
            }
            sql.append(" FROM tempdb..sysindexes WHERE id = object_id('tempdb..");
            sql.append(this.tableName).append("') AND indid > 0 AND ");
            sql.append("(status & 2048) = 2048");
            this.cursorTds.executeSQL(sql.toString(), null, null, false, 0, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
            while (!this.cursorTds.getMoreResults() && !this.cursorTds.isEndOfResponse()) {
            }
            if (this.cursorTds.isResultSet() && this.cursorTds.getNextRow()) {
                Object[] row = this.cursorTds.getRowData();
                int i3 = 0;
                while (i3 < row.length) {
                    String name = (String)row[i3];
                    if (name != null) {
                        int c = 0;
                        while (c < this.columns.length) {
                            if (this.columns[c].realName != null && this.columns[c].realName.equalsIgnoreCase(name)) {
                                this.columns[c].isKey = true;
                                this.isKeyed = true;
                                break;
                            }
                            ++c;
                        }
                    }
                    ++i3;
                }
            }
        }
        if (!this.isKeyed) {
            int i4 = 0;
            while (i4 < this.columns.length) {
                String type = this.columns[i4].sqlType;
                if (!(type.equals("ntext") || type.equals("text") || type.equals("image") || type.equals("timestamp") || this.columns[i4].tableName == null)) {
                    this.columns[i4].isKey = true;
                    this.isKeyed = true;
                }
                ++i4;
            }
        }
        return tableSet.size() == 1 && this.isKeyed;
    }

    private boolean cursorFetch(int rowNum) throws SQLException {
        this.rowUpdated = false;
        if (this.cursorName != null) {
            if (!this.cursorTds.getNextRow()) {
                StringBuffer sql = new StringBuffer(128);
                if (this.isSybase && this.sizeChanged) {
                    sql.append("SET CURSOR ROWS ").append(this.fetchSize);
                    sql.append(" FOR ").append(this.cursorName);
                    sql.append("\r\n");
                }
                sql.append("FETCH ").append(this.cursorName);
                this.cursorTds.executeSQL(sql.toString(), null, null, false, this.statement.getQueryTimeout(), this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
                while (!this.cursorTds.getMoreResults() && !this.cursorTds.isEndOfResponse()) {
                }
                this.sizeChanged = false;
                if (!this.cursorTds.isResultSet() || !this.cursorTds.getNextRow()) {
                    this.pos = -1;
                    this.currentRow = null;
                    return false;
                }
            }
            this.currentRow = this.statement.getTds().getRowData();
            ++this.pos;
            this.rowsInResult = this.pos;
            return this.currentRow != null;
        }
        if (this.rowsInResult == 0) {
            this.pos = 0;
            this.currentRow = null;
            return false;
        }
        if (rowNum == this.pos) {
            return true;
        }
        if (rowNum < 1) {
            this.currentRow = null;
            this.pos = 0;
            return false;
        }
        if (rowNum > this.rowsInResult) {
            this.currentRow = null;
            this.pos = -1;
            return false;
        }
        this.pos = rowNum;
        this.currentRow = (Object[])this.rowData.get(rowNum - 1);
        boolean bl = this.rowDeleted = this.currentRow == null;
        if (this.resultSetType == 1005 && this.currentRow != null) {
            this.refreshRow();
        }
        return true;
    }

    private void cursorClose() throws SQLException {
        if (this.cursorName != null) {
            this.statement.clearWarnings();
            String sql = this.isSybase ? "CLOSE " + this.cursorName + "\r\nDEALLOCATE CURSOR " + this.cursorName : "CLOSE " + this.cursorName + "\r\nDEALLOCATE " + this.cursorName;
            this.cursorTds.submitSQL(sql);
        }
        this.rowData = null;
    }

    protected ParamInfo buildParameter(int pos, ColInfo info, Object value) throws SQLException {
        int length = 0;
        if (value instanceof String) {
            length = ((String)value).length();
        } else if (value instanceof byte[]) {
            length = ((byte[])value).length;
        } else if (value instanceof BlobImpl) {
            BlobImpl blob = (BlobImpl)value;
            value = blob.getBinaryStream();
            length = (int)blob.length();
        } else if (value instanceof ClobImpl) {
            ClobImpl clob = (ClobImpl)value;
            value = clob.getCharacterStream();
            length = (int)clob.length();
        }
        ParamInfo param = new ParamInfo(info, null, value, length);
        param.isUnicode = info.sqlType.equals("nvarchar") || info.sqlType.equals("nchar") || info.sqlType.equals("ntext");
        param.markerPos = pos;
        return param;
    }

    protected void setColValue(int colIndex, int jdbcType, Object value, int length) throws SQLException {
        ParamInfo pi;
        super.setColValue(colIndex, jdbcType, value, length);
        if (!this.onInsertRow && this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        ColInfo ci = this.columns[--colIndex];
        if (this.onInsertRow) {
            pi = this.insertRow[colIndex];
            if (pi == null) {
                pi = new ParamInfo(-1);
                pi.collation = ci.collation;
                pi.charsetInfo = ci.charsetInfo;
                this.insertRow[colIndex] = pi;
            }
        } else {
            if (this.updateRow == null) {
                this.updateRow = new ParamInfo[this.columnCount];
            }
            if ((pi = this.updateRow[colIndex]) == null) {
                pi = new ParamInfo(-1);
                pi.collation = ci.collation;
                pi.charsetInfo = ci.charsetInfo;
                this.updateRow[colIndex] = pi;
            }
        }
        if (value == null) {
            pi.value = null;
            pi.length = 0;
            pi.jdbcType = ci.jdbcType;
            pi.isSet = true;
        } else {
            pi.value = value;
            pi.length = length;
            pi.isSet = true;
            pi.jdbcType = jdbcType;
            pi.isUnicode = ci.sqlType.equals("ntext") || ci.sqlType.equals("nchar") || ci.sqlType.equals("nvarchar");
        }
    }

    ParamInfo[] buildWhereClause(StringBuffer sql, ArrayList params, boolean select) throws SQLException {
        sql.append(" WHERE ");
        if (this.cursorName != null) {
            sql.append(" CURRENT OF ").append(this.cursorName);
        } else {
            int count = 0;
            int i = 0;
            while (i < this.columns.length) {
                if (this.currentRow[i] == null) {
                    if (count > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.columns[i].realName);
                    sql.append(" IS NULL");
                } else if (this.isKeyed && select) {
                    if (this.columns[i].isKey) {
                        if (count > 0) {
                            sql.append(" AND ");
                        }
                        sql.append(this.columns[i].realName);
                        sql.append("=?");
                        ++count;
                        params.add(this.buildParameter(sql.length() - 1, this.columns[i], this.currentRow[i]));
                    }
                } else if (!(this.columns[i].sqlType.equals("text") || this.columns[i].sqlType.equals("ntext") || this.columns[i].sqlType.equals("image") || this.columns[i].tableName == null)) {
                    if (count > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.columns[i].realName);
                    sql.append("=?");
                    ++count;
                    params.add(this.buildParameter(sql.length() - 1, this.columns[i], this.currentRow[i]));
                }
                ++i;
            }
        }
        return params.toArray(new ParamInfo[params.size()]);
    }

    protected void refreshKeyedRows() throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        int count = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (!this.columns[i].isKey && this.columns[i].tableName != null) {
                if (count > 0) {
                    sql.append(',');
                }
                sql.append(this.columns[i].realName);
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        sql.append(" FROM ");
        sql.append(this.tableName);
        ArrayList params = new ArrayList();
        this.buildWhereClause(sql, params, true);
        ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
        TdsCore tds = this.statement.getTds();
        tds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
        if (!tds.isEndOfResponse()) {
            if (tds.getMoreResults() && tds.getNextRow()) {
                Object[] col = tds.getRowData();
                count = 0;
                int i2 = 0;
                while (i2 < this.columns.length) {
                    if (!this.columns[i2].isKey) {
                        this.currentRow[i2] = col[count++];
                    }
                    ++i2;
                }
            } else {
                this.currentRow = null;
            }
        } else {
            this.currentRow = null;
        }
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        if (this.currentRow == null) {
            this.rowData.set(this.pos - 1, null);
            this.rowDeleted = true;
        }
    }

    protected void refreshReRead() throws SQLException {
        int savePos = this.pos;
        this.cursorCreate(this.sql, this.procName, this.procedureParams);
        this.absolute(savePos);
    }

    public void setFetchSize(int size) throws SQLException {
        this.sizeChanged = size != this.fetchSize;
        super.setFetchSize(size);
    }

    public void afterLast() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != -1) {
            this.cursorFetch(this.rowsInResult + 1);
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != 0) {
            this.cursorFetch(0);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.updateRow != null) {
            this.rowUpdated = false;
            int i = 0;
            while (i < this.updateRow.length) {
                if (this.updateRow[i] != null) {
                    this.updateRow[i].clearInValue();
                }
                ++i;
            }
        }
    }

    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.cursorClose();
                Object var2_1 = null;
                this.closed = true;
                this.statement = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                this.statement = null;
                throw throwable;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        StringBuffer sql = new StringBuffer(128);
        ArrayList params = new ArrayList();
        sql.append("DELETE FROM ");
        sql.append(this.tableName);
        ParamInfo[] parameters = this.buildWhereClause(sql, params, false);
        this.updateTds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
        int updateCount = 0;
        while (!this.updateTds.isEndOfResponse()) {
            if (this.updateTds.getMoreResults() || !this.updateTds.isUpdateCount()) continue;
            updateCount = this.updateTds.getUpdateCount();
        }
        this.updateTds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        if (updateCount == 0) {
            throw new SQLException(Messages.get("error.resultset.deletefail"), "24000");
        }
        this.rowDeleted = true;
        this.currentRow = null;
        if (this.resultSetType != 1003) {
            this.rowData.set(this.pos - 1, null);
        }
    }

    public void insertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.notinsrow"), "24000");
        }
        if (!this.tempResultSet) {
            StringBuffer sql = new StringBuffer(128);
            String dbName = this.columns[0].catalog;
            String userName = this.columns[0].schema;
            String tableName = this.columns[0].tableName;
            ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
            sql.append("INSERT INTO ");
            if (dbName != null) {
                sql.append(dbName);
                sql.append('.');
                if (userName == null) {
                    sql.append('.');
                }
            }
            if (userName != null) {
                sql.append(userName);
                sql.append('.');
            }
            sql.append(tableName);
            int sqlLen = sql.length();
            sql.append(" (");
            int count = 0;
            int i = 0;
            while (i < this.columnCount) {
                if (this.insertRow[i] != null) {
                    if (count > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.columns[i].realName);
                    ++count;
                }
                ++i;
            }
            sql.append(") VALUES(");
            count = 0;
            int i2 = 0;
            while (i2 < this.columnCount) {
                if (this.insertRow[i2] != null) {
                    if (count > 0) {
                        sql.append(", ");
                    }
                    sql.append("?");
                    this.insertRow[i2].markerPos = sql.length() - 1;
                    params.add(this.insertRow[i2]);
                    ++count;
                }
                ++i2;
            }
            sql.append(')');
            if (count == 0) {
                sql.setLength(sqlLen);
                sql.append(" DEFAULT VALUES");
            }
            ParamInfo[] parameters = params.toArray(new ParamInfo[params.size()]);
            this.updateTds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
            int updateCount = 0;
            while (!this.updateTds.isEndOfResponse()) {
                if (this.updateTds.getMoreResults() || !this.updateTds.isUpdateCount()) continue;
                updateCount = this.updateTds.getUpdateCount();
            }
            this.updateTds.clearResponseQueue();
            this.statement.getMessages().checkErrors();
            if (updateCount < 1) {
                throw new SQLException(Messages.get("error.resultset.insertfail"), "24000");
            }
        }
        if (this.resultSetType == 1005 || this.resultSetType == 1003 && this.cursorName == null) {
            ConnectionJDBC2 con = (ConnectionJDBC2)this.statement.getConnection();
            Object[] row = this.newRow();
            int i = 0;
            while (i < this.insertRow.length) {
                if (this.insertRow[i] != null) {
                    row[i] = Support.convert(con, this.insertRow[i].value, this.columns[i].jdbcType, con.getCharset());
                }
                ++i;
            }
            this.rowData.add(row);
        }
        ++this.rowsInResult;
        ++this.initialRowCnt;
        int i = 0;
        while (this.insertRow != null && i < this.insertRow.length) {
            if (this.insertRow[i] != null) {
                this.insertRow[i].clearInValue();
            }
            ++i;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.insertRow = null;
        this.onInsertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.insertRow = new ParamInfo[this.columnCount];
        this.onInsertRow = true;
    }

    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.concurrency == 1008) {
            this.cancelRowUpdates();
            this.rowUpdated = false;
        }
        if (this.resultSetType == 1003 || this.currentRow == null) {
            return;
        }
        if (this.isKeyed) {
            this.refreshKeyedRows();
        } else {
            this.refreshReRead();
        }
    }

    public void updateRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.rowUpdated = false;
        this.rowDeleted = false;
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        if (this.updateRow == null) {
            return;
        }
        boolean keysChanged = false;
        StringBuffer sql = new StringBuffer(128);
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
        sql.append("UPDATE ");
        sql.append(this.tableName);
        sql.append(" SET ");
        int count = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.updateRow[i] != null) {
                if (count > 0) {
                    sql.append(", ");
                }
                sql.append(this.columns[i].realName);
                sql.append("=?");
                this.updateRow[i].markerPos = sql.length() - 1;
                params.add(this.updateRow[i]);
                ++count;
                if (this.columns[i].isKey) {
                    keysChanged = true;
                }
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        ParamInfo[] parameters = this.buildWhereClause(sql, params, false);
        this.updateTds.executeSQL(sql.toString(), null, parameters, false, 0, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), true);
        int updateCount = 0;
        while (!this.updateTds.isEndOfResponse()) {
            if (this.updateTds.getMoreResults() || !this.updateTds.isUpdateCount()) continue;
            updateCount = this.updateTds.getUpdateCount();
        }
        this.updateTds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        if (updateCount == 0) {
            throw new SQLException(Messages.get("error.resultset.updatefail"), "24000");
        }
        if (this.resultSetType != 1004) {
            ConnectionJDBC2 con = (ConnectionJDBC2)this.statement.getConnection();
            int i2 = 0;
            while (i2 < this.updateRow.length) {
                if (this.updateRow[i2] != null) {
                    this.currentRow[i2] = Support.convert(con, this.updateRow[i2].value, this.columns[i2].jdbcType, con.getCharset());
                }
                ++i2;
            }
        }
        if (keysChanged && this.resultSetType == 1005) {
            this.rowData.add(this.currentRow);
            this.rowsInResult = this.rowData.size();
            this.rowData.set(this.pos - 1, null);
            this.currentRow = null;
            this.rowDeleted = true;
        } else {
            this.rowUpdated = true;
        }
        this.cancelRowUpdates();
    }

    public boolean first() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        return this.cursorFetch(1);
    }

    public boolean isLast() throws SQLException {
        this.checkOpen();
        return this.pos == this.rowsInResult && this.rowsInResult != 0;
    }

    public boolean last() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        return this.cursorFetch(this.rowsInResult);
    }

    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.pos != -1) {
            return this.cursorFetch(this.pos + 1);
        }
        return false;
    }

    public boolean previous() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos == -1) {
            this.pos = this.rowsInResult + 1;
        }
        return this.cursorFetch(this.pos - 1);
    }

    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        return this.rowDeleted;
    }

    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (row < 1) {
            row = this.rowsInResult + 1 + row;
        }
        return this.cursorFetch(row);
    }

    public boolean relative(int row) throws SQLException {
        this.checkScrollable();
        if (this.pos == -1) {
            return this.absolute(this.rowsInResult + 1 + row);
        }
        return this.absolute(this.pos + row);
    }
}

