/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "Globals.h"
#include "CConfig.h"
#include "Config.h"
#include <qintdict.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qsound.h>
#include <qapplication.h>
#include <qmessagebox.h>

#include "CMessageWindow.h"
#include "CHistoryView.h"
#include "Icons.h"

int g_widgetID = 1;
int g_serverID = 0;  //used for updating the servers list
int g_historySize = 0;
bool g_isMDI = true;
bool g_saveWorkspace = true;
bool g_confirmCritical = true;
bool g_syntaxHighlight = true;
bool g_parenthesesMatching = true;
bool g_completion = true;
QFont g_printerFont;
QString g_CONNECTION_PATH = QString(CONNECTIONS_PATH);
QString g_CONFIG_FILE = QString(CODENAME) + ".cfg";

QWidget *g_MainWidget;
QWorkspace *g_WorkSpace;
CHistoryView *g_HistoryList = new CHistoryView();
QPtrList<CMyWindow> g_WindowList;
QDict<QString> *g_PasswordDict = new QDict<QString>();
QIntDict<QString> *g_ServersDict = new QIntDict<QString>();
QIntDict<SqlFormat> *g_SqlEditorStyles = new QIntDict<SqlFormat>();
QDict<SQLKeyWord> *g_KeywordDict = new QDict<SQLKeyWord>();
QDict<QPixmap> *g_IconsDict = new QDict<QPixmap>(111);
QIntDict<DBKeyWord> *g_DBKeywordDict = new QIntDict<DBKeyWord>();
QTranslator *g_Translator;
QString *g_TranslationsPath = new QString();
QString *g_CurrentLanguage = new QString();
QString *g_CurrentStyle = new QString();
QString *g_SyntaxFile = new QString();
QString g_errorSoundFile = QString::null;
QString g_warningSoundFile = QString::null;
QString g_informationSoundFile = QString::null;

const QPixmap getPixmapIcon(const QString &name)
{
  QPixmap *p = g_IconsDict->find(name);
  return ((p == 0) ? QPixmap(0,0) : *p);
}

void myShowWindow(CMyWindow *wnd)
{
  switch (wnd->windowState) {
    case Qt::WState_Maximized:
      wnd->showMaximized();
      break;
      /* Bug in Qt
    case Qt::WState_Minimized:
      wnd->showMinimized();
      break;
      */
    default:
      wnd->show();
      break;
  }
}

void playSound(const QString &fileName)
{
  if (!QSound::isAvailable() || fileName.isEmpty())
    return;
  if (!QFile::exists(fileName))
    return;
  QSound::play(fileName);
}

QString getSaveName(const QString &fileName, const QString &default_ext, const QString &ext_desc)
{
  QString fn = QFileDialog::getSaveFileName(fileName, ext_desc, 0);
  if (!fn.isEmpty())
  {
    if (!default_ext.isNull())
    {
      if (!fn.contains("." + default_ext, false))
        fn += "." + default_ext;
    }
    return fn;
  }
  return QString::null;
}

bool tempFileName(const QString &path, QString &tmp)
{
  bool b = true;
  int x = 9000;
  while (b)
  {
    x--;
    if (x <= 0)
      return false;
    if (!QFile::exists(path + tmp + "." + QString::number(x)))
    {
      tmp += "." + QString::number(x);
      return true;
    }
  }
  return false;
}

QString capitalize(const QString &s)
{
  if (s.isEmpty())
    return s;
  QString t = s.lower();
  t[0] = t[0].upper();
  return t;
}

void saveToFile(QString &fileName, const QString &default_ext, const QString &ext_desc, const char * contents, CMessagePanel *m, bool writeBinary, uint len)
{
  QString fn = getSaveName(fileName, default_ext, ext_desc);  
  if ( !fn.isEmpty() )		
  {
    QFile file( fn );    
    if (file.exists() && g_confirmCritical)
      if ((QMessageBox::warning(0, qApp->translate("SaveToFile", "Replace File"), qApp->translate("SaveToFile", "The specified file name already exists.\nDo you want to replace it ?"),
        QMessageBox::Yes, QMessageBox::No) != QMessageBox::Yes))
        return;
    if ( !file.open( IO_WriteOnly ) )
    {
      if (m)
        m->Critical(qApp->translate("saveToFile", "An error occurred while saving the file"));
      return;
    }
    fileName = fn;
    if (!writeBinary)
    {
      QTextStream ts( &file );
      ts << contents;
    }
    else
    {      
      QDataStream ts( &file );
      ts.writeRawBytes(contents, len);
    }
    file.close();
    if (m)      
      m->Information(qApp->translate("saveToFile", "Successfully saved:") + " " + fn);
  }	
}

void freeResources()
{
#ifdef DEBUG
  qDebug( "Globals::freeResources - start");
#endif
  if (!g_WindowList.isEmpty() && !g_isMDI)
  {
    CMyWindow *w;
    QPtrListIterator<CMyWindow> it(g_WindowList);
    while ((w = it.current()) != 0 )
    {
      ++it;
      w->forceDelete(true);
      delete w;
    }
    g_WindowList.clear();
  }
  if (g_Translator)
    delete g_Translator;
  delete g_PasswordDict;
  QIntDictIterator<QString> it( *g_ServersDict ); 
  for ( ; it.current(); ++it )
    delete it.current();
  delete g_ServersDict;
  delete g_TranslationsPath;
  delete g_CurrentLanguage;
  delete g_CurrentStyle;
  delete g_SqlEditorStyles;
  delete g_SyntaxFile;
  delete g_KeywordDict;
  delete g_DBKeywordDict;
  delete g_HistoryList;
  delete g_IconsDict;
  
#ifdef DEBUG
  qDebug( "Globals::freeResources - end");
#endif
}

QString nice_time(ulong sec)
{
  QString buff;  
  ulong tmp;
  if (sec >= 3600L*24)
  {
    tmp=sec/(3600L*24);
    sec-=3600L*24*tmp;
    buff += QString::number(tmp);
    buff += (tmp > 1) ? " " + qApp->translate("nice_time", "days") + " " : " " + qApp->translate("nice_time", "day") + " ";
  }
  if (sec >= 3600L)
  {
    tmp=sec/3600L;
    sec-=3600L*tmp;
    buff += QString::number(tmp);
    buff += (tmp > 1) ? " " + qApp->translate("nice_time", "hours") + " " : " " + qApp->translate("nice_time", "hour") + " ";    
  }
  if (sec >= 60)
  {
    tmp=sec/60;
    sec-=60*tmp;
    buff += QString::number(tmp);
    buff += " " + qApp->translate("nice_time", "min") + " ";
  }
  buff += QString::number(sec);
  buff += " " + qApp->translate("nice_time", "sec") + " ";
  return buff;  
}

void setTranslation()
{
  if (g_Translator)
  {
    qApp->removeTranslator(g_Translator);
    delete g_Translator;
  }
  g_Translator = new QTranslator(0);
  Q_CHECK_PTR(g_Translator);
  g_Translator->load(*g_TranslationsPath + QString("/") + *g_CurrentLanguage, "." );
  qApp->installTranslator(g_Translator);    
}

QString booltostr(bool b)
{
  return ((b) ? "true" : "false");
}

QString booltoyesno(bool b)
{
  return ((b) ? qApp->translate("booltoyesno", "Yes") : qApp->translate("booltoyesno", "No"));
}


bool strtobool(const QString & b)
{
  return ((b.lower() == "true") ? true : false);
}

bool strInCSVList(const QString & lst, const QString & str, bool caseSensitive)
{		
  if (lst.isEmpty())
    return true;
  QString str1 = str;
  if (!caseSensitive)
    str1 = str1.lower();
  QStringList list = QStringList::split (",", lst);
  
  for ( QStringList::Iterator i = list.begin(); i != list.end(); ++i )
  {
    QString str2 = (*i);
    if (!caseSensitive)
      str2 = str2.lower();
    if (str2 == str1)
      return true;
  }
  return false;	
}

char *charReplace(char *str, char from, char to)
{
  char *s;
  if (str) {
    s = str;
    while (*s) {
      if (*s == from)
        *s = to;
      s++;
    }
  }
  return (str);
}


void striptags(char *rbuf)
{
  char *tbuf, *buf, *p, *tp, *rp, c, lc;
  int br, i=0, state=0, len;
  len = strlen(rbuf);
  buf = strdup(rbuf);
  c = *buf;
  lc = '\0';
  p = buf;
  rp = rbuf;
  br = 0;
  tp=NULL;
  tbuf=NULL;
  while(i<len)
  { 
    switch (c)
    {
    case '<':
      if (state == 0)
      {
        lc = '<';
        state = 1;
      }
      break;
      
    case '(':
      if (state == 2)
      {
        if (lc != '\"')
        {
          lc = '(';
          br++;
        }
      }
      else
        if (state == 0)
          *(rp++) = c;
        break;	
        
    case ')':
      if (state == 2)
      {
        if (lc != '\"')
        {
          lc = ')';
          br--;
        }
      } 
      else
        if (state == 0)
          *(rp++) = c;					
        break;	
        
    case '>':
      if (state == 1)
      {
        lc = '>';
        state = 0;				
      }
      else
        if (state == 2)					
          if (!br && lc != '\"' && *(p-1)=='?')
          {
            state = 0;
            tp = tbuf;
          }					
          break;
          
    case '\"':
      if (state == 2)
      {
        if (lc == '\"')					
          lc = '\0';					
        else
          if (lc != '\\')					
            lc = '\"';					
      }
      else
        if (state == 0)					
          *(rp++) = c;					
        break;
        
    case '?':
      if (state==1 && *(p-1)=='<')
      {
        br=0;
        state=2;
        break;
      }
      
    default:
      if (state == 0)				
        *(rp++) = c;				
      break;
    }
    c = *(++p);
    i++;
  }	
  *rp = '\0';
  free(buf);	
}


QString stripHtmlTags(const QString & str)
{
  char *p = (char *) malloc((sizeof(char *) * str.length()));
  strcpy (p, str.latin1());
  striptags(p);
  QString ret(p);
  free(p);
  return ret;
}

QString charReplace(const QString & Str, const QChar & From, const QString & To)
{
  QString tmpStr = "";
  for (uint i=0; i < Str.length(); i++)
  {
    QChar Tmp = Str.at(i);
    tmpStr += (Tmp == From) ? To : Tmp;		
  }
  return tmpStr;
}


bool validateAlphaNum(const QString & Str)
{	
  extern const char validcharacters[];
  QString validChars = validcharacters;	
  for (uint i=0; i < Str.length() ; i++)
  {
    QChar Tmp = Str.at(i);
    if ((!Tmp.isLetterOrNumber()) && (validChars.find(Tmp) == -1))
      return false;
  }
  return true;
}

bool validateAlphaNum(QString *Str, const QChar & Replace)
{	
  extern const char validcharacters[];
  QString validChars = validcharacters;
  if (validateAlphaNum(*Str))
  {
    QString tmpStr;
    for (uint i=0; i < Str->length() ; i++)
    {
      QChar Tmp = Str->at(i);
      tmpStr += ((!Tmp.isLetterOrNumber()) && (validChars.find(Tmp) == -1)) ? Replace : Tmp;
    }
    *Str = tmpStr;
  }
  return false;
}

QString getFileName(QString fileWithPath)
{
  fileWithPath = charReplace(fileWithPath, '\\', "/");
  int pos = fileWithPath.findRev('/');
  if (pos == -1)
    return fileWithPath;
  return fileWithPath.mid(pos + 1); 
}

void init_icons()
{
  g_IconsDict->insert("aboutIcon", new QPixmap((const char**)aboutIcon_data));
  g_IconsDict->insert("applicationIcon", new QPixmap((const char**)applicationIcon_data));
  g_IconsDict->insert("copyIcon", new QPixmap((const char**)copyIcon_data));
  g_IconsDict->insert("cutIcon", new QPixmap((const char**)cutIcon_data));
  g_IconsDict->insert("findIcon", new QPixmap((const char**)findIcon_data));
  g_IconsDict->insert("openIcon", new QPixmap((const char**)openIcon_data));
  g_IconsDict->insert("pasteIcon", new QPixmap((const char**)pasteIcon_data));
  g_IconsDict->insert("printIcon", new QPixmap((const char**)printIcon_data));
  g_IconsDict->insert("redoIcon", new QPixmap((const char**)redoIcon_data));
  g_IconsDict->insert("saveIcon", new QPixmap((const char**)saveIcon_data));
  g_IconsDict->insert("undoIcon", new QPixmap((const char**)undoIcon_data));
  g_IconsDict->insert("newWindowIcon", new QPixmap((const char**)newWindowIcon_data));
  g_IconsDict->insert("pkIcon", new QPixmap((const char**)pkIcon_data));
  g_IconsDict->insert("mulIcon", new QPixmap((const char**)mulIcon_data));
  g_IconsDict->insert("uniIcon", new QPixmap((const char**)uniIcon_data));
  g_IconsDict->insert("nothingIcon", new QPixmap((const char**)nothingIcon_data));
  g_IconsDict->insert("otherIcon", new QPixmap((const char**)otherIcon_data));
  g_IconsDict->insert("refreshIcon", new QPixmap((const char**)refreshIcon_data));
  g_IconsDict->insert("closedFolderIcon", new QPixmap((const char**)closedFolderIcon_data));
  g_IconsDict->insert("databaseConnectedIcon", new QPixmap((const char**)databaseConnectedIcon_data));
  g_IconsDict->insert("databaseConnectIcon", new QPixmap((const char**)databaseConnectIcon_data));
  g_IconsDict->insert("databaseDisconnectedIcon", new QPixmap((const char**)databaseDisconnectedIcon_data));
  g_IconsDict->insert("databaseDisconnectIcon", new QPixmap((const char**)databaseDisconnectIcon_data));
  g_IconsDict->insert("deleteIcon", new QPixmap((const char**)deleteIcon_data));
  g_IconsDict->insert("designIcon", new QPixmap((const char**)designIcon_data));
  g_IconsDict->insert("exportTableIcon", new QPixmap((const char**)exportTableIcon_data));
  g_IconsDict->insert("importTableIcon", new QPixmap((const char**)importTableIcon_data));
  g_IconsDict->insert("newTableIcon", new QPixmap((const char**)newTableIcon_data));
  g_IconsDict->insert("openFolderIcon", new QPixmap((const char**)openFolderIcon_data));
  g_IconsDict->insert("openTableIcon", new QPixmap((const char**)openTableIcon_data));
  g_IconsDict->insert("refreshTablesIcon", new QPixmap((const char**)refreshTablesIcon_data));
  g_IconsDict->insert("registerServerIcon", new QPixmap((const char**)registerServerIcon_data));
  g_IconsDict->insert("serverConnectedIcon", new QPixmap((const char**)serverConnectedIcon_data));
  g_IconsDict->insert("serverDisconnectedIcon", new QPixmap((const char**)serverDisconnectedIcon_data));
  g_IconsDict->insert("tableIcon", new QPixmap((const char**)tableIcon_data));
  g_IconsDict->insert("toolsIcon", new QPixmap((const char**)toolsIcon_data));
  g_IconsDict->insert("editIcon", new QPixmap((const char**)editIcon_data));
  g_IconsDict->insert("newDatabaseIcon", new QPixmap((const char**)newDatabaseIcon_data));
  g_IconsDict->insert("trashIcon", new QPixmap((const char**)trashIcon_data));
  g_IconsDict->insert("saveAllIcon", new QPixmap((const char**)saveAllIcon_data));
  g_IconsDict->insert("cascadeIcon", new QPixmap((const char**)cascadeIcon_data));
  g_IconsDict->insert("exitIcon", new QPixmap((const char**)exitIcon_data));
  g_IconsDict->insert("closeIcon", new QPixmap((const char**)closeIcon_data));
  g_IconsDict->insert("closeAllIcon", new QPixmap((const char**)closeAllIcon_data));
  g_IconsDict->insert("tileIcon", new QPixmap((const char**)tileIcon_data));
  g_IconsDict->insert("windowIcon", new QPixmap((const char**)windowIcon_data));
  g_IconsDict->insert("selectQueryIcon", new QPixmap((const char**)selectQueryIcon_data));
  g_IconsDict->insert("tablesIcon", new QPixmap((const char**)tablesIcon_data));
  g_IconsDict->insert("appendQueryIcon", new QPixmap((const char**)appendQueryIcon_data));
  g_IconsDict->insert("cancelQueryIcon", new QPixmap((const char**)cancelQueryIcon_data));
  g_IconsDict->insert("deleteQueryIcon", new QPixmap((const char**)deleteQueryIcon_data));
  g_IconsDict->insert("executeQueryIcon", new QPixmap((const char**)executeQueryIcon_data));
  g_IconsDict->insert("gridIcon", new QPixmap((const char**)gridIcon_data));
  g_IconsDict->insert("newTableQueryIcon", new QPixmap((const char**)newTableQueryIcon_data));
  g_IconsDict->insert("queryTypesIcon", new QPixmap((const char**)queryTypesIcon_data));
  g_IconsDict->insert("sqlIcon", new QPixmap((const char**)sqlIcon_data));
  g_IconsDict->insert("updateQueryIcon", new QPixmap((const char**)updateQueryIcon_data));
  g_IconsDict->insert("contextHelpIcon", new QPixmap((const char**)contextHelpIcon_data));
  g_IconsDict->insert("fontsIcon", new QPixmap((const char**)fontsIcon_data));
  g_IconsDict->insert("stylesIcon", new QPixmap((const char**)stylesIcon_data));
  g_IconsDict->insert("hammerIcon", new QPixmap((const char**)hammerIcon_data));
  g_IconsDict->insert("renameTableIcon", new QPixmap((const char**)renameTableIcon_data));
  g_IconsDict->insert("serverAdministrationIcon", new QPixmap((const char**)serverAdministrationIcon_data));
  g_IconsDict->insert("showVariablesIcon", new QPixmap((const char**)showVariablesIcon_data));
  g_IconsDict->insert("showStatusIcon", new QPixmap((const char**)showStatusIcon_data));
  g_IconsDict->insert("showProcessListIcon", new QPixmap((const char**)showProcessListIcon_data));
  g_IconsDict->insert("pingIcon", new QPixmap((const char**)pingIcon_data));
  g_IconsDict->insert("serverShutdownIcon", new QPixmap((const char**)serverShutdownIcon_data));
  g_IconsDict->insert("flushIcon", new QPixmap((const char**)flushIcon_data));
  g_IconsDict->insert("timerIcon", new QPixmap((const char**)timerIcon_data));
  g_IconsDict->insert("killProcessIcon", new QPixmap((const char**)killProcessIcon_data));
  g_IconsDict->insert("warningIcon", new QPixmap((const char**)warningIcon_data));
  g_IconsDict->insert("criticalIcon", new QPixmap((const char**)criticalIcon_data));
  g_IconsDict->insert("informationIcon", new QPixmap((const char**)informationIcon_data));
  g_IconsDict->insert("propertiesIcon", new QPixmap((const char**)propertiesIcon_data));
  g_IconsDict->insert("chooseFieldsIcon", new QPixmap((const char**)chooseFieldsIcon_data));
  g_IconsDict->insert("clearGridIcon", new QPixmap((const char**)clearGridIcon_data));
  g_IconsDict->insert("checkedIcon", new QPixmap((const char**)checkedIcon_data));
  g_IconsDict->insert("uncheckedIcon", new QPixmap((const char**)uncheckedIcon_data));
  g_IconsDict->insert("loadIcon", new QPixmap((const char**)loadIcon_data));
  g_IconsDict->insert("savePixmapIcon", new QPixmap((const char**)savePixmapIcon_data));
  g_IconsDict->insert("flipHIcon", new QPixmap((const char**)flipHIcon_data));
  g_IconsDict->insert("flipVIcon", new QPixmap((const char**)flipVIcon_data));
  g_IconsDict->insert("rotateIcon", new QPixmap((const char**)rotateIcon_data));
  g_IconsDict->insert("bits32Icon", new QPixmap((const char**)bits32Icon_data));
  g_IconsDict->insert("bits8Icon", new QPixmap((const char**)bits8Icon_data));
  g_IconsDict->insert("bit1Icon", new QPixmap((const char**)bit1Icon_data));
  g_IconsDict->insert("historyScriptIcon", new QPixmap((const char**)historyScriptIcon_data));
  g_IconsDict->insert("saveGridResultsIcon", new QPixmap((const char**)saveGridResultsIcon_data));
  g_IconsDict->insert("userIcon", new QPixmap((const char**)userIcon_data));
  g_IconsDict->insert("databaseUsersIcon", new QPixmap((const char**)databaseUsersIcon_data));
  g_IconsDict->insert("newUserIcon", new QPixmap((const char**)newUserIcon_data));
  g_IconsDict->insert("editUserIcon", new QPixmap((const char**)editUserIcon_data));
  g_IconsDict->insert("deleteUserIcon", new QPixmap((const char**)deleteUserIcon_data));
  g_IconsDict->insert("databaseUsersDisconnectedIcon", new QPixmap((const char**)databaseUsersDisconnectedIcon_data));
  g_IconsDict->insert("globalPrivsIcon", new QPixmap((const char**)globalPrivsIcon_data));
  g_IconsDict->insert("printerFontIcon", new QPixmap((const char**)printerFontIcon_data));
}

