/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CUserItem.h"
#include "CUserAdminWindow.h"

CUserItem::CUserItem(CMyWindow *consoleWindow, CDatabaseTreeItem * parent, const QString &username, const QString &hostname, QWidgetStack *w)
: CDatabaseTreeItem(parent), m_UserName(username), m_HostName(hostname)
{		
  m_pMySQLServer = ((CDatabaseTreeItem *)this->parent())->m_pMySQLServer;
  deleteMySQL = false;
  init_item(w, consoleWindow);  
}

CUserItem::CUserItem(CMyWindow *consoleWindow, QListView * parent, CMySQLConnection *mysql, const QString &username, const QString &hostname, QWidgetStack *w)
: CDatabaseTreeItem(parent), m_UserName(username), m_HostName(hostname)
{	
  m_pMySQLServer = mysql;
  deleteMySQL = true;	
  init_item(w, consoleWindow);
  setOpen(true);
}

CUserItem::~CUserItem()
{  
  if (deleteMySQL)
    delete m_pMySQLServer;  
}

void CUserItem::init_item(QWidgetStack *w, CMyWindow *consoleWindow)
{  
  ConsoleWindow = consoleWindow;
  setType(USER_ITEM);
  setName("CUserItem");
  setText(0,m_UserName + "@" + m_HostName);
  widgetStack = w;  
  setPixmap(0, getPixmapIcon("userIcon"));
}

void CUserItem::processMenu(int res)
{
  switch (res) {
  case MENU_DELETE:
    {
      if (CUserAdminWindow::removeUser(ConsoleWindow, m_pMySQLServer, m_UserName, m_HostName))
      {        
        CDatabaseTreeItem *p = (CDatabaseTreeItem *) this->parent();
        p->listView()->setCurrentItem(p);
        p->refresh();        
      }
    }
    break;
  case MENU_NEW:
    {
      CUserAdminWindow *p = new CUserAdminWindow((QWidget *)g_WorkSpace, ConsoleWindow, m_pMySQLServer, QString::null, QString::null, false, (CDatabaseTreeItem *)this->parent());
      Q_CHECK_PTR(p);
      myShowWindow(p);
    }
    break;
  case MENU_EDIT:
    {
      bool notnew = ((m_pMySQLServer->getMySQLServerVersion().major <= 3) && (m_pMySQLServer->getMySQLServerVersion().minor <= 22));
      if (notnew)
        m_pMySQLServer->PrintError(WARNING, QObject::tr("Edit User only works for mysql >= 3.23"));
      else
      {
        CUserAdminWindow *p = new CUserAdminWindow((QWidget *)g_WorkSpace, ConsoleWindow, m_pMySQLServer, m_UserName, m_HostName, true, (CDatabaseTreeItem *)this->parent());
        Q_CHECK_PTR(p);
        myShowWindow(p);
      }
    }
    break;
  }
}

void CUserItem::doubleClicked()
{
  processMenu(MENU_EDIT);
}

int CUserItem::displayMenu(const QPoint &pos)
{  
  QPopupMenu *p_itemMenu = new QPopupMenu();
  Q_CHECK_PTR(p_itemMenu);
  p_itemMenu->insertItem(getPixmapIcon("editUserIcon"),
			 QObject::tr("Edit User"),
			 MENU_EDIT);
  p_itemMenu->insertSeparator();
  p_itemMenu->insertItem(getPixmapIcon("deleteUserIcon"),
			 QObject::tr("Delete User"), MENU_DELETE);
  p_itemMenu->insertSeparator();
  p_itemMenu->insertItem(getPixmapIcon("newUserIcon"),
       QObject::tr("Add User"),
       MENU_NEW);
  int res = p_itemMenu->exec(pos);
  delete p_itemMenu;
  return res;
}

CUserItemToolbar::CUserItemToolbar(QMainWindow * parent)
: CToolBar(USER_ITEM, QObject::tr("User"), parent, "User Toolbar")
{  
  addButton(MENU_EDIT, getPixmapIcon("editUserIcon"), QObject::tr("Edit User"));
  insertSeparator();
  addButton(MENU_DELETE, getPixmapIcon("deleteUserIcon"), QObject::tr("Delete User"));
  insertSeparator();
  addButton(MENU_NEW, getPixmapIcon("newUserIcon"), QObject::tr("Add User"));  
}

