/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CUserAdminItem.h"
#include "CUserItem.h"
#include "CUserAdminWindow.h"

CUserAdminItem::CUserAdminItem(CMyWindow *consoleWindow, CDatabaseTreeItem * parent, QWidgetStack *w)
: CDatabaseTreeItem(parent)
{
  m_pMySQLServer = ((CDatabaseTreeItem *)this->parent())->m_pMySQLServer;
  m_isConnected = false;
  init_item(w, consoleWindow);  
  deleteMySQL = false;
}

CUserAdminItem::CUserAdminItem(CMyWindow *consoleWindow, QListView * parent, bool isconnected, CMySQLConnection *mysql, QWidgetStack *w)
: CDatabaseTreeItem(parent), m_isConnected(isconnected)
{
  m_pMySQLServer = mysql;
  m_pMySQLServer->setConnected(true);
  deleteMySQL = true;
  init_item(w, consoleWindow);
}

CUserAdminItem::~CUserAdminItem()
{
  if (deleteMySQL)
    delete m_pMySQLServer;
}

void CUserAdminItem::doubleClicked()
{
  if (isRefreshing)
    return;
  if (!m_isConnected)
    setConnected(true, true);
}

bool CUserAdminItem::displayUsers(bool printErr)
{
  //TODO:  This needs to be modified to NOT use mysql.user for the users list.  SHOW GRANTS FOR % is needed in the server.
  if (isRefreshing)
    return false;
  isRefreshing = true;
  listView()->setCursor(Qt::waitCursor);
  while (this->childCount() > 0)
    deleteChilds();
  bool hasAccess = false;    
  bool b = m_pMySQLServer->isBlockingQueries();
  if (!b)
    m_pMySQLServer->setBlockingQueries(true);
  CMySQLQuery *q = new CMySQLQuery(m_pMySQLServer);
  if (q->exec("SELECT User, Host FROM mysql.user ORDER BY User", false, false))
  {
    hasAccess = true;
    while (q->next())      
      new CUserItem(ConsoleWindow, this, q->Row(0), q->Row(1), widgetStack);      
  }
  else   
    if (printErr)
      printAccessError();
  delete q;
  m_pMySQLServer->setBlockingQueries(b);
  listView()->setCursor(Qt::ArrowCursor);
  isRefreshing = false;
  return hasAccess;
}

void CUserAdminItem::printAccessError()
{
  if (m_pMySQLServer->isConnected())
    m_pMySQLServer->PrintError(CRITICAL, QObject::tr("You don't have enough privileges to access this section"));
}

void CUserAdminItem::setConnected(bool connected, bool printErr)
{
  if (isRefreshing)
    return;
  listView()->setCursor(Qt::waitCursor);
  m_isConnected = connected;  
  if (!m_isConnected)
  {
    while (this->childCount() > 0)
      deleteChilds();
  }
  else  
    if (m_isConnected = displayUsers(printErr))          
      setOpen(true);        
  setPixmap(0, getPixmapIcon(!m_isConnected ? "databaseUsersDisconnectedIcon" : "databaseUsersIcon"));  
  listView()->setCursor(Qt::ArrowCursor);
}

void CUserAdminItem::init_item(QWidgetStack *w, CMyWindow *consoleWindow)
{
  isRefreshing = false;
  ConsoleWindow = consoleWindow;
  setName("CUserAdminItem");
  setType(USER_ADMINISTRATION_ITEM);
  widgetStack = w;
  setText( 0, QObject::tr("User Administration"));
  setConnected(m_isConnected);  
}

void CUserAdminItem::doCreateUser()
{
  CUserAdminWindow *p = new CUserAdminWindow((QWidget *) g_WorkSpace, ConsoleWindow, m_pMySQLServer, QString::null, QString::null, false, this);
  Q_CHECK_PTR(p);
  myShowWindow(p);
}

void CUserAdminItem::refresh()
{
  displayUsers(true);
}

void CUserAdminItem::processMenu(int res)
{
  if (isRefreshing)
    return;
  switch (res)
  {
  case MENU_NEW: doCreateUser();
    break;
  case MENU_REFRESH: refresh();
    break;
  case MENU_DISCONNECT: setConnected(false, true);
    break;
  case MENU_CONNECT: setConnected(true, true);
    break;
  }
}

int CUserAdminItem::displayMenu(const QPoint &pos)
{
  if (isRefreshing)
    return -1;
  QPopupMenu *p_itemMenu = new QPopupMenu();
  Q_CHECK_PTR(p_itemMenu);
  p_itemMenu->insertItem(getPixmapIcon("newUserIcon"),
			 QObject::tr("Add User"),
			 MENU_NEW);
  p_itemMenu->insertSeparator();  
  if (m_isConnected)      
    p_itemMenu->insertItem(getPixmapIcon("databaseUsersDisconnectedIcon"), QObject::tr("Disconnect"), MENU_DISCONNECT);  
  else      
    p_itemMenu->insertItem(getPixmapIcon("databaseUsersIcon"), QObject::tr("Connect"), MENU_CONNECT);
  p_itemMenu->insertSeparator();
  p_itemMenu->insertItem(getPixmapIcon("refreshIcon"), QObject::tr("Refresh"), MENU_REFRESH);
  p_itemMenu->setItemEnabled(MENU_REFRESH, m_isConnected);
  p_itemMenu->insertSeparator();
  p_itemMenu->insertItem(getPixmapIcon("newWindowIcon"),
       QObject::tr("New Window from Here",""),
       NEW_WINDOW_FROM_HERE);
  int res = p_itemMenu->exec(pos);
  delete p_itemMenu;
  return res;
}

CUserAdminItemToolbar::CUserAdminItemToolbar(QMainWindow * parent)
 :CToolBar(USER_ADMINISTRATION_ITEM,
	   QObject::tr("User Administration"), parent,
	   "User Administration Toolbar")
{
  addButton(MENU_NEW, getPixmapIcon("newUserIcon"),
	    QObject::tr("Add User"));
  insertSeparator();
  addButton(MENU_CONNECT, getPixmapIcon("databaseUsersIcon"),
	    QObject::tr("Connect"));
  addButton(MENU_DISCONNECT, getPixmapIcon("databaseUsersDisconnectedIcon"),
	    QObject::tr("Disconnect"));
  insertSeparator();
  addButton(MENU_REFRESH, getPixmapIcon("refreshIcon"),
      QObject::tr("Refresh"));
  insertSeparator();
  addButton(NEW_WINDOW_FROM_HERE, getPixmapIcon("newWindowIcon"),
	    QObject::tr("Open in New Window"));
}

void CUserAdminItemToolbar::setConnectedToolbar(bool connected)
{
  Button(1)->setEnabled(!connected);
  Button(2)->setEnabled(connected);
}

