/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CTablesListBox.h"

CTablesListBox::CTablesListBox( QWidget * parent, const char * name, CMySQLConnection *m, QString tableName)
: QListBox( parent, name)
{	
  setSelectionMode(QListBox::Extended);
  numItems = -1;
  m_pMysql = m;
  m_tableName = tableName;
  init();
}

void CTablesListBox::displayMenu(QListBoxItem *, const QPoint & pos)
{
  QPopupMenu *p_itemMenu = new QPopupMenu();
  Q_CHECK_PTR(p_itemMenu);  
  p_itemMenu->insertItem(getPixmapIcon("refreshTablesIcon"), tr("Refresh"), 1);
  if (p_itemMenu->exec(pos) == 1)
    refresh();
  delete p_itemMenu;	
}

void CTablesListBox::showEvent( QShowEvent * )
{
  refresh();
}

void CTablesListBox::refresh()
{
  clear();
  int j = -1;  
  if (m_pMysql->isConnected())
  {
    CMySQLQuery query(m_pMysql);
    QString sql = "SHOW TABLES";
    if (query.exec(sql, false))
      while (query.next())
      {
        insertItem(getPixmapIcon("tableIcon"), query.Row(0), ++j);
        if (query.Row(0) == m_tableName)
        {
          setSelected(item(j), true);
          setCurrentItem(j);
          centerCurrentItem();
        }
      }
  }
  numItems = j;
  if (count() < 0)
    emit(notablesloaded());
}

QString CTablesListBox::selectedTables()
{
  QString ret = "";
  for (int i=0; i <= numItems; i++)
    if (isSelected (i))
      ret += m_pMysql->Quote(text(i)) + ", ";
    if (!ret.isEmpty())
      return ret.left(ret.length() - 2);
    return (QString) 0;
}

QStringList CTablesListBox::selectedTablesList()
{
  QStringList list;	
  for (int i=0; i <= numItems; i++)
    if (isSelected (i))
      list.append(text(i));
    return list;
}

CTablesListBox::~CTablesListBox()
{
}

void CTablesListBox::init()
{
  connect(this, SIGNAL(rightButtonClicked(QListBoxItem *, const QPoint &)), this, SLOT(displayMenu(QListBoxItem *, const QPoint &)));
}

