/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CShowTableProperties.h"
#include "CTableTools.h"
#include "CTableSpecific.h"
#include "syntaxhighliter_sql.h"

CShowTableProperties::CShowTableProperties(QWidget * parent, int serverid, CMySQLConnection *conn) 
: CSqlTable(parent, conn), m_TableName(QString::null)
{
  serverID = serverid;
  setLeftMargin(0);
  setName("CShowTableProperties");
  verticalHeader()->hide(); 
  setReadOnly(true);
  setFocusStyle(QTable::FollowStyle);
  setSelectionMode(QTable::SingleRow);
  widgetStack = (QWidgetStack *) parent;  
}

void CShowTableProperties::setTableName(const QString &tableName)
{
  m_TableName = tableName;
  setQuery("SHOW COLUMNS FROM " + m_pDatabaseConnection->Quote(m_TableName));
}

void CShowTableProperties::exec()
{
  reset();  
  if (Query->exec(m_Query, false))
  {		    
    setNumRows(Query->numRows());
    setNumCols(Query->numFields());
    for (unsigned int i = 0; i < Query->numFields(); i++)
      horizontalHeader()->setLabel(i,QString::fromLatin1(Query->Fields[i].name));

    unsigned long j = 0;    
    DBKeyWord *dbk = g_DBKeywordDict->find(serverID);
    QString icon;
    while (Query->next())
    {
      if (dbk != NULL)
      {
        dbk->addTable(Query->Row(0));
        dbk->addTable(m_TableName + "." + Query->Row(0));
        dbk->addTable(getDatabaseConnection()->getDatabaseName() + "." + m_TableName + "." + Query->Row(0));
      }
      for (unsigned int i = 0; i < Query->numFields(); i++)
      {
        setText(j,i, Query->Row(i));
        if (i == 3)
        {
          if (Query->Row(3) == "PRI")
            icon = "pkIcon";            
          else
            if (Query->Row(3) == "MUL")
              icon = "mulIcon";              
            else
              if (Query->Row(3) == "UNI")
                icon = "uniIcon";                
              else
                if (Query->Row(3) == "")
                  icon = "nothingIcon";                  
                else
                  icon = "otherIcon";                
                setPixmap(j,0, getPixmapIcon(icon));          
        }
      }
      j++;	
    }		
  }
}

void CShowTableProperties::exec(const QString &tableName)
{
  setTableName(tableName);
  exec();
}

void CShowTableProperties::processMenu(int res, int, int)
{
  if (CTableTools::inRange(res))
    CTableTools::processMenu(widgetStack, m_pDatabaseConnection, res, m_TableName, serverID);
  else
    switch (res)
		{
      case MENU_EDIT: CTableSpecific::editTable(m_pDatabaseConnection, m_TableName);
        break;
      case MENU_REFRESH: exec();
        break;					
		}
}

int CShowTableProperties::displayMenu(const QPoint &pos)
{
  QPopupMenu *p_itemMenu = new QPopupMenu();  
  p_itemMenu->insertItem(getPixmapIcon("designIcon"), "Edit Table", MENU_EDIT);
  
  p_itemMenu->insertSeparator();
  
  QPopupMenu *p_toolsMenu = CTableTools::tableToolsMenu();  
  p_itemMenu->insertItem(getPixmapIcon("toolsIcon"), "Tools", p_toolsMenu, MENU_TOOLS);
  p_itemMenu->insertSeparator();  
  p_itemMenu->insertItem(getPixmapIcon("refreshTablesIcon"), "Refresh", MENU_REFRESH);
  
  //Disable features that aren't currently working
  p_itemMenu->setItemEnabled(MENU_EDIT, false);  //Disable 'Edit Table'

  bool notnew = ((getDatabaseConnection()->getMySQLServerVersion().major <= 3) && (getDatabaseConnection()->getMySQLServerVersion().minor <= 22));
  if (notnew)  //Disable unsupported features for mysql <= 3.22
    p_itemMenu->setItemEnabled(MENU_TOOLS, false);  //Disable 'Table Tools'    

  int res = p_itemMenu->exec(pos);
  delete p_itemMenu;	
  delete p_toolsMenu;
  return res;	
}

void CShowTableProperties::DoubleClicked (int row, int, int button, const QPoint &)
{	
  if ((row > -1) && (button == 1))
    CTableSpecific::editTable(m_pDatabaseConnection, m_TableName);
}

