/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CShowServerProperties.h"

CShowServerProperties::CShowServerProperties(QWidget* parent, CMySQLConnection *m)
: CListViewProperties(parent, m, "CShowServerProperties")
{
  details->addColumn(tr("Property"));
  details->addColumn(tr("Value"));
  details->header()->setClickEnabled(false, 1);
  setSaveTitle(tr("Connection Properties"));
}

void CShowServerProperties::refresh()
{
  title->setText(" " + mysql->getConnectionName());
  CListViewProperties::refresh();
}

void CShowServerProperties::insertData()
{
  insertItem(tr("Connected"), booltoyesno(mysql->isConnected()));
  insertItem(tr("Host Name"), mysql->getHostName());
  insertItem(tr("Date Created"), mysql->getCreated());
  insertItem(tr("Date Modified"), mysql->getModified());
  insertItem(tr("User Name"), mysql->getUserName());
  insertItem(tr("Using Blocking Queries"), booltoyesno(mysql->isBlockingQueries()));
  insertItem(tr("Using Compression"), booltoyesno(mysql->isCompressed()));
  insertItem(tr("Using Prompt for Password"), booltoyesno(mysql->isPromptPassword()));
  insertItem(tr("Using a Single Connection"), booltoyesno(mysql->isOneConnection()));
  insertItem(tr("Has Syntax Highlighting and Completion"), booltoyesno(mysql->hasCompletion()));
  insertItem(tr("Fields Separated by"), mysql->getFieldSeparator());
  insertItem(tr("Fields Enclosed by"), mysql->getFieldEncloser());  
  insertItem(tr("Lines Terminated by"), mysql->getLineTerminator());
  insertItem(tr("Replace Empty fields with"), mysql->getReplaceEmpty());
  if (mysql->isSocket())
    insertItem(tr("Socket File"), mysql->getSocketName());
  else
    insertItem(tr("Port"), QString::number(mysql->getPort()));
  insertItem(tr("MySQL Server version"), mysql->getServerVersion());
  insertItem(tr("MySQL Protocol version"), mysql->getProtoInfo());
  insertItem(tr("MySQL Connection version"), mysql->getHostInfo());
  insertItem(tr("MySQL Uptime"), mysql->getUptime());
}

