/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CServerAdministrationItem.h"

CServerAdministrationItem::CServerAdministrationItem(CMyWindow *consoleWindow, CDatabaseTreeItem * parent, QWidgetStack *w)
: CDatabaseTreeItem(parent)
{
  m_pMySQLServer = ((CDatabaseTreeItem *)this->parent())->m_pMySQLServer;	
  init_item(w, consoleWindow);
  deleteMySQL = false;
}

CServerAdministrationItem::CServerAdministrationItem(CMyWindow *consoleWindow, QListView * parent, CMySQLConnection *mysql, QWidgetStack *w)
: CDatabaseTreeItem(parent)
{
  m_pMySQLServer = mysql;
  m_pMySQLServer->setConnected(true);
  setOpen(true);
  deleteMySQL = true;
  init_item(w, consoleWindow);
}

CServerAdministrationItem::~CServerAdministrationItem()
{
  if (deleteMySQL)
    delete m_pMySQLServer;
  widgetStack->removeWidget(serverAdministrationProperties);
  delete serverAdministrationProperties;
}

void CServerAdministrationItem::clicked()
{
  serverAdministrationProperties->refresh();
  widgetStack->raiseWidget(widgetID);
}

void CServerAdministrationItem::init_item(QWidgetStack *w, CMyWindow *consoleWindow)
{
  ConsoleWindow = consoleWindow;
  setName("CServerAdministrationItem");
  setType(SERVER_ADMINISTRATION_ITEM);
  widgetStack = w;
  setText( 0, QObject::tr("Server Administration"));  
  setPixmap(0, getPixmapIcon("serverAdministrationIcon"));  
  serverAdministrationProperties = new CShowDatabaseGroupProperties((QWidget *) widgetStack, m_pMySQLServer);
  Q_CHECK_PTR(serverAdministrationProperties);
  widgetID = getWidgetID();
  widgetStack->addWidget (serverAdministrationProperties, widgetID);
}

void CServerAdministrationItem::doubleClicked()
{	
  processMenu(MENU_SHOW_PROCESSLIST);
}

void CServerAdministrationItem::processMenu(int res)
{
  int type = -1;
  if (CAdministrationPanel::inRange(res))
    CAdministrationPanel::processMenu(ConsoleWindow, res, m_pMySQLServer);
  else
    switch (res)
  {
    case MENU_SHOW_PROCESSLIST: type = SHOW_PROCESSLIST;
      break;
    case MENU_SHOW_STATUS: type = SHOW_STATUS;
      break;
    case MENU_SHOW_VARIABLES: type = SHOW_VARIABLES;
      break;
  }
  if (type != -1)
  {
    CAdministrationPanel *p = new CAdministrationPanel(g_WorkSpace, type, m_pMySQLServer);
    Q_CHECK_PTR(p);
    myShowWindow(p);
  }
}

int CServerAdministrationItem::displayMenu(const QPoint &pos)
{
  QPopupMenu *p_itemMenu = new QPopupMenu();
  Q_CHECK_PTR(p_itemMenu);
   
  p_itemMenu->insertItem(getPixmapIcon("showProcessListIcon"),
			 QObject::tr("Show Process List"),
			 MENU_SHOW_PROCESSLIST);
  p_itemMenu->insertItem(getPixmapIcon("showStatusIcon"),
			 QObject::tr("Show Status"), MENU_SHOW_STATUS);
  p_itemMenu->insertItem(getPixmapIcon("showVariablesIcon"),
			 QObject::tr("Show Variables"), MENU_SHOW_VARIABLES);

  p_itemMenu->insertSeparator();
  QPopupMenu *p_flushMenu = new QPopupMenu();
  Q_CHECK_PTR(p_flushMenu);
  CAdministrationPanel::FlushMenu(p_flushMenu);
  p_itemMenu->insertItem(getPixmapIcon("flushIcon"), QObject::tr("Flush"),
			 p_flushMenu);
  p_itemMenu->insertItem(getPixmapIcon("pingIcon"), QObject::tr("Ping"), MENU_PING);
  p_itemMenu->insertItem(getPixmapIcon("serverShutdownIcon"), QObject::tr("Shutdown"), MENU_SHUTDOWN);

  p_itemMenu->insertSeparator();

  p_itemMenu->insertItem(getPixmapIcon("newWindowIcon"),
			 QObject::tr("New Window from Here"),
			 NEW_WINDOW_FROM_HERE);
  int res =  p_itemMenu->exec(pos);
  delete p_itemMenu;
  delete p_flushMenu;
  return res;
}

CServerAdministrationItemToolbar::CServerAdministrationItemToolbar(QMainWindow * parent)
 :CToolBar(SERVER_ADMINISTRATION_ITEM,
	   QObject::tr("Server Administration"), parent,
	   "Server Administration Toolbar")
{  
  addButton(MENU_SHOW_PROCESSLIST, getPixmapIcon("showProcessListIcon"),
	    QObject::tr("Show Process List"));
  addButton(MENU_SHOW_STATUS, getPixmapIcon("showStatusIcon"), QObject::tr("Show Status"));
  addButton(MENU_SHOW_VARIABLES, getPixmapIcon("showVariablesIcon"),
	    QObject::tr("Show Variables"));

  insertSeparator();
  p_flushMenu = new QPopupMenu();
  Q_CHECK_PTR(p_flushMenu);
  CAdministrationPanel::FlushMenu(p_flushMenu);
  addButton(p_flushMenu, getPixmapIcon("flushIcon"), QObject::tr("Flush"));
  addButton(MENU_PING, getPixmapIcon("pingIcon"), QObject::tr("Ping"));
  addButton(MENU_SHUTDOWN, getPixmapIcon("serverShutdownIcon"), QObject::tr("Shutdown"));
  insertSeparator();

  addButton(NEW_WINDOW_FROM_HERE, getPixmapIcon("newWindowIcon"),
	    QObject::tr("Open in New Window"));
}

CServerAdministrationItemToolbar::~CServerAdministrationItemToolbar()
{
  delete p_flushMenu;
}
