/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include <qapplication.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qdir.h>
#include <qmessagebox.h>
#include "CHistoryView.h"
#include "Globals.h"

CHistoryView::CHistoryView()
{
#ifdef DEBUG
  qDebug("CHistoryView::CHistoryView()");
#endif
  historyList.setAutoDelete(true);  
}

CHistoryView::~CHistoryView()
{
#ifdef DEBUG
  qDebug("CHistoryView::~CHistoryView()");
#endif
  write();
}

// TODO: optimize this - name should be put together once and then cached
QString CHistoryView::getHistoryFile()
{
  return QDir::homeDirPath() + "/." + QString(CODENAME) + "/" + QString(HISTORY_FILE_NAME);
}

void CHistoryView::load()
{
#ifdef DEBUG
  qDebug("CHistoryView::load()");
#endif
  QFile f_strm(getHistoryFile());
  if (f_strm.open(IO_ReadWrite))
  {
#ifdef DEBUG
    qDebug("CHistoryView::load() - loading ...");
#endif
    QTextStream t_strm(&f_strm);
    if (!historyList.isEmpty())
      historyList.clear();
    uint i = 0;
    while ( !t_strm.atEnd() )    
      historyList.insert(i++, new QString(t_strm.readLine()));
    f_strm.close();   
  }
#ifdef DEBUG
  qDebug("CHistoryView::load() - finished ...");
#endif
  truncate();
}

void CHistoryView::loadTo(CHistoryPanel *h)
{
  if (historyList.isEmpty())  
    return;  
  truncate();
  QIntDictIterator<QString> it(historyList);
  for ( ; it.current(); ++it)
    h->History(*it.current(), false);
}

void CHistoryView::truncate()
{
  if (historyList.count() == 0 || historyList.isEmpty())
    return;
  int start = historyList.count() - g_historySize;  
  if (start > 0)  
    for (int i = 0; i < start; i++)
      historyList.remove(i);
}

void CHistoryView::write()
{
  truncate();
  if (historyList.isEmpty())
    return;
  QFile file(getHistoryFile());
  if (!file.open( IO_WriteOnly ))
  {    
    QMessageBox::critical(0, qApp->translate("CHistoryView", "Error"), qApp->translate("CHistoryView", "An error occurred while saving the history list."));
    return;
  }    
  QTextStream ts( &file );  
  QIntDictIterator<QString> it(historyList);
  for ( ; it.current(); ++it)
    ts << it.current()->simplifyWhiteSpace() << "\n";
  file.close();
}

void CHistoryView::append(const QString &s)
{
  if (historyList.size() >= (uint)(g_historySize) -5)
    historyList.resize(historyList.count() + 5);
  historyList.insert(historyList.count(), new QString(s));
}

