/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include <qvariant.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qwidget.h>

#include "CFieldEditorWindow.h"
#include "CMyWindow.h"
#include "Globals.h"
#include "Config.h"

CFieldEditorWindow::CFieldEditorWindow(QWidget* parent, QPtrList<CFieldEditorWindow> *editorList, const char* name, CMySQLConnection *m, bool ro)
:CSmallMyWindow( parent, name, WDestructiveClose, !g_isMDI), readOnly(ro) 
{
#ifdef DEBUG
  qDebug("CFieldEditorWindow()");
#endif
  EditorList = editorList;
  mysql = m;
  if ( !name )
    setName( "CFieldEditorWindow" );  
  setIcon(getPixmapIcon("applicationIcon"));  
  setCaption(tr("Table Editor" ) );

  setCentralWidget( new QWidget(this, "qt_central_widget"));  
  CFieldEditorWindowLayout = new QGridLayout(centralWidget(), 1, 1, 2, 2, "CFieldEditorWindowLayout");   
  
  Frame5 = new QFrame(centralWidget(), "Frame5" );
  Frame5->setFrameShape( QFrame::Box );
  Frame5->setFrameShadow( QFrame::Sunken );
  Frame5Layout = new QHBoxLayout( Frame5, 4, 6, "Frame5Layout"); 
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );    
  Frame5Layout->addItem( spacer );

  applyPushButton = new QPushButton( Frame5, "applyPushButton" );
  applyPushButton->setMinimumSize( QSize( 70, 0 ) );
  applyPushButton->setText(tr("&Apply" ) );
  Frame5Layout->addWidget( applyPushButton );
  applyPushButton->setEnabled(!ro);

  cancelPushButton = new QPushButton( Frame5, "cancelPushButton" );
  cancelPushButton->setMinimumSize( QSize( 70, 0 ) );
  cancelPushButton->setText(tr("&Cancel" ) );
  Frame5Layout->addWidget( cancelPushButton );
  CFieldEditorWindowLayout->addWidget( Frame5, 1, 0 );
  init();
  EditorList->append((CFieldEditorWindow *)this);
  myResize( 520, 350 );
}

CFieldEditorWindow::~CFieldEditorWindow()
{  
  EditorList->remove(this);
}

void CFieldEditorWindow::applyButtonClicked()
{
  //This function needs to update the data in the DB Table.
  close();
}

void CFieldEditorWindow::init()
{
  connect(applyPushButton, SIGNAL(clicked()), this, SLOT(applyButtonClicked()));
  connect(cancelPushButton, SIGNAL(clicked()), this, SLOT(close()));
}
