/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CConfigDialog.h"

CConfigDialog::CConfigDialog(QWidget* parent,  const char* name)
:CMyWindow( parent, name, WDestructiveClose, !g_isMDI)
{
  if ( !name )
    setName( "CConfigDialog" );  
  setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, sizePolicy().hasHeightForWidth() ) );  
  setMaximumSize( QSize( 32767, 32767));  
  setIcon(getPixmapIcon("applicationIcon"));
  setCentralWidget( new QWidget(this, "qt_central_widget"));  
  CConfigDialogLayout = new QVBoxLayout(centralWidget(), 4, 2, "CConfigDialogLayout"); 
  Q_CHECK_PTR(CConfigDialogLayout);
  
  Tab = new QTabWidget(centralWidget(), "Tab" );
  Q_CHECK_PTR(Tab);
  QWhatsThis::add( Tab, tr("This is the Configuration Dialog." ) );
  
  CConfigDialogLayout->addWidget( Tab );
  
  Layout44 = new QHBoxLayout(0, 0, 6, "Layout44");

  PushButton4 = new QPushButton(centralWidget(), "PushButton4" );
  Q_CHECK_PTR(PushButton4);
  PushButton4->setText("");    
  PushButton4->setPixmap(getPixmapIcon("contextHelpIcon"));
  Layout44->addWidget( PushButton4 );

  customButton = new QPushButton(centralWidget(), "customButton" );
  Q_CHECK_PTR(customButton);
  Layout44->addWidget(customButton);
  customButton->hide();

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout44->addItem( spacer );

  okPushButton = new QPushButton(centralWidget(), "okPushButton" );
  Q_CHECK_PTR(okPushButton);
  okPushButton->setMinimumSize( QSize( 60, 0 ) );
  okPushButton->setText( tr("&Ok" ) );
  okPushButton->setDefault( TRUE );  
  Layout44->addWidget( okPushButton );

  cancelPushButton = new QPushButton(centralWidget(), "cancelPushButton" );
  Q_CHECK_PTR(cancelPushButton);
  cancelPushButton->setMinimumSize( QSize( 70, 0 ) );
  cancelPushButton->setText( tr("&Cancel" ) );
  QWhatsThis::add( cancelPushButton, tr("Close this Dialog without saving any changes you have made." ) );
  Layout44->addWidget( cancelPushButton );
  CConfigDialogLayout->addLayout( Layout44 );
  
  init();
}

void CConfigDialog::insertTab (QWidget * child, int index)
{
  Q_CHECK_PTR(child);
  Tab->insertTab(child, child->caption(), index);
}

void CConfigDialog::insertTab (QWidget * child, const QIconSet & iconset, int index)
{
  Q_CHECK_PTR(child);
  Tab->insertTab(child, iconset, child->caption(), index);
}

CConfigDialog::~CConfigDialog()
{
}

void CConfigDialog::setDefaultValues(CConfig *conn)
{  
  for (int i = 0; i < Tab->count(); i++)
    ((privateTabConfig *)Tab->page(i))->setDefaultValues(conn);  
}

QString CConfigDialog::validate()
{
  QString Err = QString::null;
  for (int i = 0; i < Tab->count(); i++)
    Err += ((privateTabConfig *)Tab->page(i))->validate();
  return Err;  
}

bool CConfigDialog::save(CConfig *conn, bool doflush)
{	
  bool ret = true;
  if (!doflush)
    ret &= conn->prepare();
  for (int i = 0; i < Tab->count(); i++)
    ret &= ((privateTabConfig *)Tab->page(i))->save(conn);  
  if (doflush)
    ret &= conn->flush();
  return ret;
}

void CConfigDialog::init()
{
  connect(okPushButton, SIGNAL(clicked()), this, SLOT(okButtonClicked()));
  connect(cancelPushButton, SIGNAL(clicked()), this, SLOT(close()));
  connect(PushButton4, SIGNAL(clicked()), this, SLOT(whatsThis()));
}

