/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CONFIG_H
#define CONFIG_H

#ifndef NDEBUG
#define DEBUG
#define DBUG
#endif

#include "Globals.h"

#define APPLICATION "MySQL Control Center"
#define CODENAME "MyCC"
#define VERSION "0.8.2 alpha"
#define COPYRIGHT "Copyright (C) MySQL AB & Jorge del Conde 2002"

const char validcharacters[] = "-_.+@:;,[](){}~#$!";

#ifdef WIN32  //Default MDI for Windows, SDI for other OS
#define IS_MDI  true
#else
#define IS_MDI  false
#endif

#define MAX_BLOB_SIZE 512
#define CONNECTIONS_PATH  "Connections"
#define HISTORY_FILE_NAME "history"

#define NEW_WINDOW_FROM_HERE  0

#define SHOW_PROCESSLIST 0
#define SHOW_STATUS 1
#define SHOW_VARIABLES 2

#define WARNING 0
#define CRITICAL 1
#define INFORMATION 2

#define MENU_CONNECT  1
#define MENU_DISCONNECT 2
#define MENU_QUERY  3
#define MENU_DELETE  4
#define MENU_NEW  5
#define MENU_REFRESH  6
#define MENU_EDIT 7
#define MENU_EXPORT 8
#define MENU_EMPTY  9
#define MENU_RENAME 10
#define MENU_IMPORT 11
#define MENU_SHOW 12
#define MENU_HIDE 13
#define MENU_NEW_WINDOW 14
#define MENU_SHOW_VARIABLES 15
#define MENU_SHOW_STATUS 16
#define MENU_SHOW_PROCESSLIST 17
#define MENU_PING 18
#define MENU_FLUSH 19
#define MENU_SHUTDOWN 20
#define MENU_KILL_PROCESS 21
#define MENU_PROPERTIES 22
#define MENU_SAVE 23
#define MENU_SAVE_ALL 24
#define MENU_SAVE_PROCESSLIST 25
#define MENU_SAVE_STATUS 26
#define MENU_SAVE_VARIABLES 27
#define MENU_COLUMNS_WINDOW 28
#define MENU_CLEAR_GRID 29
#define MENU_TRADITIONAL 30
#define MENU_OPEN 31
#define MENU_OPEN_AS 32
#define MENU_OPEN_TEXT 33
#define MENU_OPEN_IMAGE 34
#define MENU_OPEN_BINARY 35
#define MENU_LOAD 36
#define MENU_SHOW_TREE 37
#define MENU_HIDE_TREE 38
#define MENU_SHOW_MESSAGES 39
#define MENU_HIDE_MESSAGES 40
#define MENU_TOOLS 41

#define SQL_ALL_ROWS  1100
#define SQL_LIMIT  1101
#define SQL_QUERY  1102
#define SQL_PANEL  1103
#define RESULTS_PANEL  1104
#define ERROR_PANEL 1105
#define HISTORY_PANEL 1106

#define SERVER_ITEM 2000
#define DATABASE_ITEM 2001
#define TABLE_ITEM  2002
#define DATABASE_GROUP  2003
#define DATABASE_USERS_GROUP  2004
#define TABLE_GROUP 2005
#define SERVER_ADMINISTRATION_ITEM 2006
#define USER_ADMINISTRATION_ITEM 2007
#define USER_ITEM 2008

#define ANALYZE_TABLE 3000
#define CHECK_TABLE 3001
#define OPTIMIZE_TABLE 3002
#define REPAIR_TABLE 3003
#define SHOW_CREATE_TABLE 3004

#define FLUSH_HOSTS 3500
#define FLUSH_LOGS 3501
#define FLUSH_PRIVILEGES 3502
#define FLUSH_TABLES 3503
#define FLUSH_TABLES_RL 3504
#define FLUSH_STATUS 3505

#define TYPE_IMAGE  4000
#define TYPE_PIXMAP 4001

#endif

