/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CUSERADMINWINDOW_H
#define CUSERADMINWINDOW_H

#include <qwidget.h>
#include <qvariant.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "CMyWindow.h"
#include "Config.h"
#include "CConfig.h"

class privateDatabaseItem : public QCheckListItem
{
public:
  privateDatabaseItem (QListView * parent, const QString &dbname, int t=DATABASE_ITEM);
  privateDatabaseItem (privateDatabaseItem * parent);
  int getType() { return type; }
  QString getDatabaseName() { return m_dbname; }
  QDict<bool> itemPrivileges;
  void stateChange (bool);
  void setType(int t) { type = t; }
  bool allPrivs;
  bool withGrant;

protected:
  void init(int t);
  QString m_dbname;  

private:  
  int type;
};

class privateTableItem : public privateDatabaseItem
{
public:  
  privateTableItem (privateDatabaseItem * parent, const QString &tablename);
  QString getTableName() { return m_tablename; }

private:
  QString m_tablename;
};

class CUserAdminWindow : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CUserAdminWindow(QWidget* parent, CMyWindow *consoleWindow, CMySQLConnection *m, const QString &username=QString::null, const QString &hostname=QString::null, bool isediting=false, CDatabaseTreeItem *item=0);
  ~CUserAdminWindow();
  static bool removeUser(CMyWindow *consoleWindow, CMySQLConnection *m, const QString &username, const QString &hostname);
  bool isRestrictedPrivilege(const QString &s);
  void reset();
  
public slots:
  void applyClicked();

private slots:  
  void allPrivilegesToggled(bool b);
  void deleteClicked();
  void withGrantToggled(bool b);
  void databaseListViewMenu(QListViewItem *, const QPoint &, int);
  void setCurrentItemPrivileges(QListViewItem *);
  void privilegeListBoxChanged();
  
private:
  class SelectedItems
  {
  public:
    SelectedItems(const QString &i, bool allprivs, bool withgrant, const QDict<bool> &privileges)
    {
      item = i;
      privs = privileges;
      allPrivs = allprivs;
      withGrant = withgrant;
    }
    ~SelectedItems() {}
    QString item;
    QDict<bool> privs;
    bool allPrivs;
    bool withGrant;
  };
  
  struct UserGrants
  {  
    UserGrants() {}   
    ~UserGrants() {}
    QString item;
    QStringList privileges;
    bool withGrant;
    bool allPrivs;
  };

  void init();
  void listPrivileges();
  void listDatabases();
  void setUserGrants();
  void parseUserGrants();
  void selectFirstItem();
  void closeEvent(QCloseEvent * e);
  privateDatabaseItem *findItem(const QString &txt, int type);
  void initItemPrivileges(privateDatabaseItem *item);
  bool execute(const QString &access, bool allPrivs, bool withGrant, const QDict<bool> &Privileges);
  QPtrList<SelectedItems> selectedItems;
  QPtrList<UserGrants> userGrants;
  void deletePrivileges();
  bool blockPrivilegeListBox;
  bool prepareAccessTo();
  bool m_refresh;
  CDatabaseTreeItem *treeItem;
  CMySQLConnection *mysql;
  CMyWindow *ConsoleWindow;
  QString m_Username;
  QString m_Hostname;
  bool isEditing;  
  QLineEdit* Password;
  QLabel* hostLabel;
  QLabel* passwordLabel;
  QLineEdit* Host;
  QButtonGroup* ButtonGroup1;
  QCheckBox* allPrivileges;
  QCheckBox* withGrantOption;
  QListBox* privilegeListBox;
  QLineEdit* Username;
  QLabel* usernameLabel;  
  QListView* databaseListView;
  QPushButton* applyButton;
  QPushButton* cancelButton;
  QPushButton* deleteButton;
  QGridLayout* CUserAdminWindowLayout;
  QGridLayout* ButtonGroup1Layout;  
  QHBoxLayout* Layout6;
};

#endif // CUSERADMINWINDOW_H
