/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CUSERADMINITEM_H
#define CUSERADMINITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>

#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"

#include "Config.h"

class CDatabaseTreeItem;
class CMySQLConnection;

class CUserAdminItemToolbar : public CToolBar
{
  Q_OBJECT

public:
  CUserAdminItemToolbar(QMainWindow * parent);
  void setConnectedToolbar(bool connected);
};

class CUserAdminItem : public CDatabaseTreeItem
{     
public:
  CUserAdminItem(CMyWindow *consoleWindow, CDatabaseTreeItem * parent, QWidgetStack *w = NULL);
  CUserAdminItem(CMyWindow *consoleWindow, QListView * parent = 0, bool isconnected = false, CMySQLConnection *mysql = 0, QWidgetStack *w = NULL);
  ~CUserAdminItem();  
  void init_item(QWidgetStack *w, CMyWindow *consoleWindow);
  int displayMenu(const QPoint & pos);  
  void processMenu(int res);
  void doubleClicked();
  void doCreateUser();
  void setConnected (bool c, bool printErr = false);
  bool isConnected() { return m_isConnected; }
  void refresh();

private:
  bool displayUsers(bool printErr);
  void printAccessError();
  bool deleteMySQL;  
  bool m_isConnected;
  bool isRefreshing;
};

#endif
