/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#ifndef CTEXTFIELDEDITOR_H
#define CTEXTFIELDEDITOR_H

#include <qvariant.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>

#include "CFieldEditorWindow.h"
#include "CTextEditor.h"
#include "Globals.h"
#include "Config.h"

class CTextFieldEditor : public CFieldEditorWindow
{
  Q_OBJECT
    
public:
  CTextFieldEditor(QWidget* parent, QPtrList<CFieldEditorWindow> *editorList, const char* name = 0, CMySQLConnection *m=0, bool ro=false);
  ~CTextFieldEditor();
  CTextEditor * editor;
  void setText(const QString &txt);
  QString getText();


private slots:
  void SelectionChanged();

private:
  void init();
  QMenuBar *menubar;
  QPopupMenu *fileMenu;
  QPopupMenu *editMenu;

  QToolBar *toolBar;

  QAction* fileOpenAction;
  QAction* fileSaveAsAction;
  QAction* filePrintAction;
  QAction* fileCloseAction;
  QAction* editUndoAction;
  QAction* editRedoAction;
  QAction* editCutAction;
  QAction* editCopyAction;
  QAction* editPasteAction;  
};

#endif
