/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLESPECIFIC_H
#define CTABLESPECIFIC_H

#include <qvariant.h>
#include <qdialog.h>
#include <qpopupmenu.h>
#include <qinputdialog.h>
#include "Config.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "CQueryWindow.h"

class CTableSpecific
{
  
public:
  static QPopupMenu *openTableMenu();	
  static void processMenu(CMySQLConnection *m, int res, const QString & tableName, int serverid = -1);
  static bool inRange(int res);
  
  static bool newTable(CMySQLConnection *m);
  static bool importTable(CMySQLConnection *m);
  static bool exportTable(CMySQLConnection *m, const QString & tableName);
  static void tableProperties(CMySQLConnection *m, const QString & tableName);
  static bool deleteTable(CMySQLConnection *m, const QString & tableName);
  static bool editTable(CMySQLConnection *m, const QString & tableName);
  static bool emptyTable(CMySQLConnection *m, const QString & tableName);
  static bool renameTable(CMySQLConnection *m, const QString & from, const QString & to);
  static void QueryWindow(CMySQLConnection *m, const QString & tableName, int q, int serverid = -1);
};

#endif

