/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLEPROPERTIES_H
#define CTABLEPROPERTIES_H

#include <qvariant.h>
#include <qwidgetstack.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qptrlist.h> 
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qcursor.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QGroupBox;
class QPushButton;

#include "CMyWindow.h"
#include "CListViewProperties.h"
#include "CMySQLQuery.h"
#include "CTablesListBox.h"
#include "Config.h"
#include "CSqlTable.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QPushButton;
class QGroupBox;

class privateTableProperties : public CListViewProperties
{ 
  Q_OBJECT
    
public:
  privateTableProperties(QWidget* parent,  CMySQLConnection *m, const QString & qry);
  ~privateTableProperties() {};

public slots:
  void refresh();
  
private:  
  void insertData();
  QString tableName;
};

class CTableProperties : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CTableProperties(CMySQLConnection *m , const QString &tablename, QWidget* parent = 0, const char* name = 0);
  ~CTableProperties();    
  
private: 
  privateTableProperties* tableProperties;
  QPushButton* m_pClosePushButton;
  QVBoxLayout* Form1Layout;
  QHBoxLayout* Layout1;

private slots:
  virtual void init();
};

#endif // CTABLEPROPERTIES_H

