/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLEITEM_H
#define CTABLEITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>

#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "CShowTableProperties.h"
#include "CTableSpecific.h"
#include "CTableTools.h"
#include "Config.h"

//These defines are used by CShowTables too

class CDatabaseTreeItem;

class CTableItemToolbar : public CToolBar
{
  Q_OBJECT

public:
  CTableItemToolbar(QMainWindow * parent);
  ~CTableItemToolbar();

private:
  void disableButtons(const int &maj = 0, const int &min = 0);
  QPopupMenu *p_openTableMenu;
  QPopupMenu *p_toolsMenu;
};

class CTableItem : public CDatabaseTreeItem
{     
public:
  CTableItem(CMyWindow *consoleWindow, int serverid, CDatabaseTreeItem * parent, const QString & tablename, CShowTableProperties *tableproperties, int widgetid, QWidgetStack *w=NULL);		
  ~CTableItem();  
  int displayMenu(const QPoint & pos);
  void processMenu(int res);
  void clicked();
  void doubleClicked();  
  void renamed(const QString & fromText, const QString & toText);

  //Both friends are used by CShowTableGroupProperties to display and process "right-click" menus.
  friend int f_displayMenu(const QPoint & pos, CMySQLConnection *mysql, bool disable = false);
  friend int f_processMenu(int res, CDatabaseTreeItem *p, QWidgetStack *w, CMySQLConnection *m, const QString &txt, int serverid);

private:
  CShowTableProperties * tableProperties;
  void startDrag(); 
};

#endif

