/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLEGROUPITEM_H
#define CTABLEGROUPITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include "CDatabaseTreeItem.h"
#include "CTableItem.h"
#include "CShowTableGroupProperties.h"
#include "CShowTableProperties.h"
#include "CMySQLQuery.h"
#include "CTableTools.h"
#include "Config.h"

class CDatabaseTreeItem;
class CShowTables;

class CTableGroupToolbar : public CToolBar
{
  Q_OBJECT

public:
  CTableGroupToolbar(QMainWindow * parent);
  ~CTableGroupToolbar();

private:
  QPopupMenu *p_toolsMenu;
  void disableButtons(const int &maj = 0, const int &min = 0);
};

class CTableGroupItem : public CDatabaseTreeItem
{     
public:
  CTableGroupItem(CMyWindow *consoleWindow, int serverid, CDatabaseTreeItem * parent, QWidgetStack *w=NULL);	
  CTableGroupItem(CMyWindow *consoleWindow, int serverid, QListView * parent, CMySQLConnection *mysql, QString dbname, CMySQLConnection *dbconn, QWidgetStack *w=NULL);
  ~CTableGroupItem();	
  void init_item(QWidgetStack *w, CMyWindow *consoleWindow, int serverid);
  int displayMenu(const QPoint & pos);
  void processMenu(int res);
  void refresh();
  void clicked();

  static CToolBar * createToolBar(QMainWindow * parent);

private:  
  bool isRefreshing;
  CShowTableGroupProperties * tableView;
  CShowTableProperties * tableProperties;
  QString databaseName;
  int tablePropertiesWidgetID;
  bool deleteMySQL;
};

#endif

