/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA

  Modified by: Jorge del Conde

  Original Code Copyrighted by Trolltech AS
*/

#ifndef COMPLETION_H
#define COMPLETION_H

#include <qstring.h>
#include "qrichtext_p.h"
#include <qstringlist.h>
#include <qobject.h>
#include <qdict.h>
#include <qmap.h>

class QTextDocument;
class Editor;
class QVBox;
class QListBox;

struct CompletionEntry
{
  QString type;
  QString text;
  QString postfix;
  QString prefix;
  QString postfix2;
  
  bool operator==( const CompletionEntry &c ) const
  {
    return ( c.type == type &&
      c.text.lower() == text.lower() &&
      c.postfix == postfix &&
      c.prefix == prefix &&
      c.postfix2 == postfix2 );
  }
};

class EditorCompletion : public QObject
{
  Q_OBJECT
    
public:
  EditorCompletion( Editor *e );
  ~EditorCompletion();
  
  virtual void addCompletionEntry( const QString &s, QTextDocument *doc, bool strict );
  virtual QValueList<CompletionEntry> completionList( const QString &s, QTextDocument *) const;
  bool eventFilter( QObject *o, QEvent *e );
  virtual bool doCompletion();
  void setEnabled( bool b ) { enabled = b; }
  
protected:
  virtual void showCompletion( const QValueList<CompletionEntry> &lst );
  virtual void completeCompletion();
  
protected:
  QVBox *completionPopup;
  QListBox *completionListBox;
  int completionOffset;
  Editor *curEditor;
  QString searchString;
  QValueList<CompletionEntry> cList;
  QMap<QChar, QStringList> completionMap;
  QDict<QString> caseDict;
  bool enabled;
  QTextDocument *lastDoc;
  
};

#endif
