/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CSHOWTABLEPROPERTIES_H
#define CSHOWTABLEPROPERTIES_H

#include <qwidgetstack.h>
#include "CSqlTable.h"

class CSqlTable;


class CShowTableProperties : public CSqlTable
{
public:
  CShowTableProperties(QWidget * parent, int serverid, CMySQLConnection *conn);
  QString getTableName() { return m_TableName;}
  void setTableName(const QString &tableName);  
  void exec(const QString &tableName);
  void processMenu(int res, int row, int);
  int displayMenu(const QPoint &pos);
  void DoubleClicked (int row, int, int button, const QPoint &);
  
private:
  void exec();
  int serverID;
  QString m_TableName;
  QWidgetStack *widgetStack;
};

#endif

