/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

/*
  This File contains QPopupMenu inherited classes which are shared
  between CApplicationWindow and CConsoleWindow.
*/

#ifndef CSHAREDMENUS_H
#define CSHAREDMENUS_H

#include <qvariant.h>
#include <qtooltip.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qfontdialog.h>
#include <qstylefactory.h>

#include "CGeneralConfig.h"
#include "CAboutBox.h"
#include "CCreditsBox.h"
#include "Config.h"

class QAction;
class QActionGroup;
class QPopupMenu;

class CConsoleMenu : public QPopupMenu
{ 
  Q_OBJECT

public:
  CConsoleMenu( QWidget* parent = 0, QMenuBar *menuBar = 0, const char* name = 0);
  ~CConsoleMenu(){};

protected:
  QAction*	  	m_pConsoleExitAction;
};


class CHelpMenu : public QPopupMenu
{ 
  Q_OBJECT

public:
  CHelpMenu( QWidget* parent = 0, QMenuBar *menuBar = 0, const char* name = 0);
  ~CHelpMenu(){};

public slots:  
  void ContentsAction();
  void AboutAction();
  void CreditsAction();

protected:
  QAction*	  	m_pHelpContentsAction;
  QAction*	  	m_pHelpAboutAction;
  QAction*	  	m_pHelpCreditsAction;
  QAction*	  	m_pHelpWhatIsThisAction;
};

class COptionsMenu : public QPopupMenu
{ 
  Q_OBJECT
    
public:
  COptionsMenu( QWidget* parent = 0, QMenuBar *menuBar = 0, const char* name = 0);
  ~COptionsMenu(){};

public slots:  
  void MDIAction();
  void GeneralAction();
  void themesMenuAboutToShow();
  void FontsAction();
  void PrinterFontAction();
  void styleSelected(int id);

protected:
  QAction*  		m_pOptionsMDIAction;
  QPopupMenu*   m_pThemesMenu;
  QAction*  		m_pOptionsFontsAction;
  QAction*  		m_pOptionsPrinterFontAction;
  QAction*  		m_pOptionsGeneralAction;

};

#endif

