/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CMYWINDOW_H
#define CMYWINDOW_H

#include <qmainwindow.h>
#include <qdockarea.h>
#include "CMessageWindow.h"

/*
  This class is used because when the app is running in SDI mode, Qt will not automatically
  delete all child-windows when it's closed.

  When running in SDI mode, what this class basically does is add each child-window to a global 
  QPtrList called g_WindowList.  If the user closes the window, it removes it from the list.
  If the user closes the main application while child-windows are still open, ~CConsoleWindow()
  will iterate through g_WindowList destroying all unclosed child-windows.  
*/

class CMyWindow : public QMainWindow
{ 
  Q_OBJECT
    
public:
  CMyWindow ( QWidget * parent = 0, const char * name = 0, WFlags f = WDestructiveClose, bool destroy=false, bool hasmessages = false);
  ~CMyWindow();
  void forceDelete(bool d);  
  void autoPlace();
  bool hasMessageWindow() { return m_hasMessages; }
  bool isApplicationWidget() { return m_isAppWidget; }
  void setApplicationWidget(bool b) { m_isAppWidget = b; }
  CMessageWindow *messageWindow() const { return p_messageWindow; }
  void setMessageWindow(CMessageWindow *m) { p_messageWindow = m; }
  CMessagePanel *messagePanel() const { return p_messagePanel; }  
  int windowState;
  void myResize(int w, int h);
  const QPoint myPos() { return QPoint(geometry().x(), geometry().y()); }
  virtual void beforeClose();
  virtual void saveWindowSettings();
  virtual bool loadWindowSettings(bool b=false);
  static bool findDockWindow(Dock *d, CMyWindow *wnd, QDockWindow *dockWnd);

public slots:
  void setCurrentPosition(const QPoint &p);

protected:  
  CMessageWindow *p_messageWindow;
  CMessagePanel *p_messagePanel;
  int getWindowState();
  virtual void closeEvent(QCloseEvent * e);

private:
  bool m_isAppWidget;
  bool m_hasMessages;
  bool m_forceDelete;
  bool m_destroy;
  bool m_canSaveMe;
  QPoint position;
};

class CSmallMyWindow : public CMyWindow
{
  Q_OBJECT

public:
  CSmallMyWindow ( QWidget * parent = 0, const char * name = 0, WFlags f = WDestructiveClose, bool destroy=false, int flags = 0);
  CSmallMyWindow::~CSmallMyWindow();
  virtual QSize sizeHint () const;
};

QTextStream &operator<<(QTextStream &, const CMyWindow &);
QTextStream &operator>>(QTextStream &, CMyWindow &);

#endif

