/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CMYSQLQUERY_H
#define CMYSQLQUERY_H

#include <qvariant.h>
#include "CMySQLConnection.h"

#define QUERY_FIELD_HIDDEN 0x1

class CMySQLQuery
{
public:
  CMySQLQuery(CMySQLConnection *conn);
  ~CMySQLQuery();
  void freeResult();
  void freeRow();
  CMySQLConnection *getMySQLConnection() { return m_pMySQLConnection; }  
  bool next(bool showError = true, bool autoFree = true);
  void cancel();
  bool isNull();
  unsigned long numRows();  
  inline unsigned int numFields() { return num_fields; }
  const char * getFieldValue(unsigned int offset, unsigned int index);
  bool exec(const QString &qry, bool showAffected=false, bool showError=true);
  bool exec_static(const QString &qry, bool showAffected=false, bool *printedMessage=0, bool showError=true);
  const QString Row(unsigned int idx);
  bool printAffectedRows(bool isSelectQuery, bool printAffected, bool showError=true, const QString &time = QString::null);  
  static bool ColumnQuery (QStringList &list, CMySQLConnection *m, const QString &qry, unsigned int r=0, bool blocking = false, bool showError = true);
  void dataSeek(unsigned long r);
  unsigned long getFieldLength(unsigned int index);
  void export_current_row(QTextStream& ts, QString& sep,
				     QString& encl,QString& term,
				     QString& repl_empty);
  MYSQL_FIELD *Fields;
  char* field_mask;
  unsigned int num_fields,last_field_ind;
  MYSQL_ROW row;
  bool result_in_use;
  
private:
  CMySQLConnection *m_pMySQLConnection;
  QString m_Query;	
  MYSQL_RES *res;
  bool m_cancel;
  ushort checkPendingEvt;
};

#endif
