/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#ifndef CIMAGEFIELDEDITOR_H
#define CIMAGEFIELDEDITOR_H

#include <qvariant.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>

#include "CFieldEditorWindow.h"
#include "CImageEditor.h"
#include "Globals.h"
#include "Config.h"

class CImageFieldEditor : public CFieldEditorWindow
{
  Q_OBJECT
    
public:
  CImageFieldEditor(QWidget* parent, QPtrList<CFieldEditorWindow> *editorList, const char* name = 0, CMySQLConnection *m=0, bool ro=false);
  ~CImageFieldEditor();
  CImageEditor * editor;
  void loadImage(const char *fieldname, const char *data, uint len);
  void doResize(int w, int h);
  
private slots:
  void setColorType(QAction *);
  void updateStatusBar(const QString &);
  void myMessage(int, const QString &);
  void setSaveEnabled(bool);
  void saveImage(int);
  void savePixmap(int);

private:
  void init();  
  QMenuBar *menubar;
  QPopupMenu *fileMenu;
  QPopupMenu *editMenu;
  QPopupMenu *imageMenu;

  QPopupMenu *p_saveImageTypeMenu;  
  QPopupMenu *p_savePixmapTypeMenu;
  QToolButton *saveImageTypeButton;
  QToolButton *savePixmapTypeButton;

  QToolBar *toolBar;
  QToolBar *imageBar;

  QActionGroup * colorOptions;

  QAction* fileOpenAction;
  QAction* fileCloseAction;
  QAction* editCopyAction;
  QAction* editPasteAction;

  QAction* imageAutoColorAction;
  QAction* imageColorOnlyAction;
  QAction* imageMonoColorAction;

  QAction* imageHFlipAction;
  QAction* imageVFlipAction;
  QAction* imageRotateAction;

  QAction* imageTo1BitAction;
  QAction* imageTo8BitAction;
  QAction* imageTo32BitAction;  
};

#endif
