/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#ifndef CIMAGEEDITOR_H
#define CIMAGEEDITOR_H

#include <qmainwindow.h>
#include <qwidget.h>
#include <qimage.h>

#include "CMySQLConnection.h"
#include "Config.h"
#include "Globals.h"

extern QString g_img_fname_prompt;
void init_img_fname_prompt();

class CImageEditor : public QWidget
{
  Q_OBJECT
public:
  CImageEditor( QWidget *parent, QWidget *parentwidget, const char *name=0);
  ~CImageEditor();
  bool loadImage(const char *fileName, const char *data=0, uint len=0);

signals:
  void myErr(int, const QString &);
  void statusMessage(const QString &);
  void enableDepth1(bool);
  void enableDepth8(bool);
  void enableDepth32(bool);
  void canSave(bool);

public slots:
  void doColorChange(ImageConversionFlags f);

  void openFile();
  void to1Bit();
  void to8Bit();
  void to32Bit();
  void toBitDepth(int);
  
  void copy();
  void paste();
  
  void hFlip();
  void vFlip();
  void rot180();
    
  void saveImage(const QString &);
  void savePixmap(const QString &);  
  void copyFrom(CImageEditor*);

protected:
  void paintEvent( QPaintEvent * );
  void resizeEvent( QResizeEvent * );  
  void mouseMoveEvent( QMouseEvent * );

private:
  void doSave(const QString & fmt, int type);
  void scale();
  int conversion_flags;    
  QWidget *parentWidget;    
  int	alloc_context;  
  bool convertEvent( QMouseEvent* e, int& x, int& y );
  const char* filename;
  QString fname;
  QImage image;
  QPixmap	pm;
  QPixmap	pmScaled;
  void updateStatus();
  void setMenuItemFlags();
  bool reconvertImage();
  int pickx, picky;
  int clickx, clicky;
  bool may_be_other;
  static CImageEditor* other;
  void setImage(const QImage& newimage);
};

#endif

