/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CDATABASETREEITEM_H
#define CDATABASETREEITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qwidget.h>
#include <qwidgetstack.h>
#include <qdragobject.h>
#include <qmenubar.h>
#include <qpixmap.h>
#include "syntaxhighliter_sql.h"


#include "Config.h"
#include "CToolBar.h"


class CDatabaseTree;
class QListViewItem;
class CMySQLConnection;
class QWidgetStack;
class QWidget;
class CApplicationWindow;
class QDragObject;
class QMainWindow;

class CDatabaseTreeItem : public QListViewItem
{
public:	
  CDatabaseTreeItem (QListView * parent);
  CDatabaseTreeItem (CDatabaseTreeItem * parent);
  ~CDatabaseTreeItem() {};  
  void setType(int type);
  int getType();
  void setCurrentText(const QString &t);
  void setName(const char *name);
  const char* getName();
  QString getCurrentText();
  virtual int displayMenu(const QPoint &);
  virtual bool isConnected();
  virtual void setConnected(bool) {};
  virtual void mySetOpen(bool) {};
  virtual void processMenu(int) {};
  virtual QString getTitle();
  virtual void clicked() {};
  virtual void expanded() {};
  virtual void collapsed() {};
  virtual void doubleClicked() {};
  virtual void refresh() {};
  virtual void startDrag() {};
  virtual void renamed(const QString &, const QString &) {};
  virtual void getServerVersion(int &maj, int &min);
  CMyWindow *ConsoleWindow;
  int widgetID;
  int getWidgetID();  
  void deleteChilds();
  unsigned int getServerID() { return serverID; };

  QWidgetStack * widgetStack;
  CMySQLConnection * m_pMySQLServer;	
  CMySQLConnection * m_pMySQLDatabase;
  
protected:
  int serverID;
  QString currentText;
  virtual void itemDrag(const char *t);
  
private:
  void init();
  int m_itemType;
  static QString m_className;
};

#endif

