/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CDATABASEGROUPITEM_H
#define CDATABASEGROUPITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>

#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "CShowDatabaseGroupProperties.h"
#include <qinputdialog.h>

#include "Config.h"

class CDatabaseTreeItem;
class CMySQLConnection;

class CDatabaseGroupToolbar : public CToolBar
{
  Q_OBJECT

public:
  CDatabaseGroupToolbar(QMainWindow * parent);
};

class CDatabaseGroupItem : public CDatabaseTreeItem
{     
public:
  CDatabaseGroupItem(CMyWindow *consoleWindow, int serverid, CDatabaseTreeItem * parent, bool isopen = false, QWidgetStack *w = NULL);
  CDatabaseGroupItem(CMyWindow *consoleWindow, int serverid, QListView * parent = 0, CMySQLConnection *mysql = 0, QWidgetStack *w = NULL);
  ~CDatabaseGroupItem();
  bool isOpen() { return m_isOpen; }
  void mySetOpen(bool isopen);
  void init_item(bool isopen, QWidgetStack *w, CMyWindow *consoleWindow, int serverid);
  int displayMenu(const QPoint & pos);
  void expanded();
  void collapsed();
  void processMenu(int res);
  void clicked();
  
private:
  void addDatabases(bool isRefresh);
  bool isRefreshing;
  CShowDatabaseGroupProperties * databaseGroupProperties;
  bool m_isOpen;
  bool deleteMySQL;
};

#endif

