/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CCONFIG_H
#define CCONFIG_H

class QTextStream;
class QToolButton;
class QToolBar;

#include <qdict.h>
#include <qstring.h>
#include <qstringlist.h>

class CConfig
{
public:
  CConfig(const QString &name, const QString & path = QString::null);
  ~CConfig();
  bool prepare();
  bool flush();
  bool writeEntry(const QString & key, const QString & value=QString::null);
  bool writeEntry(const QString & key, int value);
  bool exists();
  bool remove();  
  QString readStringEntry(const QString & key, const QString &def="");
  int readNumberEntry(const QString & key, int def=0);
  void setConfingName(const QString & conn) { configName = conn; }
  QString getConfigName() { return configName; }
  
  static QString getMyCCPath();
  static QString getConfigPath();
  static bool exists(const QString & name);
  static void list(QStringList &list, const QString & path);
  static void Remove(const QString & name, const QString & path);
private:
  QDict<QString> entries;
  QString configName;
  static QString Path;    
};

#endif


