/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CAPPLICATIONWINDOW_H
#define CAPPLICATIONWINDOW_H

#include <qvariant.h>   // first for gcc 2.7.2
#include <qvbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qimage.h>
#include <qapplication.h>
#include <qworkspace.h>

#include "CMyWindow.h"
#include "CConsoleWindow.h"
#include "CDatabaseTreeItem.h"
#include "CSharedMenus.h"
#include "Config.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QAction;
class QActionGroup;
class QPopupMenu;
class QWorkspace;
class QVBox;
class CConsoleWindow;

class CApplicationWindow : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CApplicationWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
  ~CApplicationWindow();
  
  QVBox*			  m_pMainBox;    
  QPopupMenu*		m_pWindowMenu;
    
  CConsoleWindow*	consoleWindow;

signals:
  void undockwindows();

public slots:  
  virtual void windowMenuAboutToShow();
  virtual void windowActivated(int id);
  
protected slots:  
  virtual void consoleWindowDisplay(int id);
  
  void closeAllSLOT();
  void CloseSLOT();

private:
  void init_signals();
  void closeEvent( QCloseEvent * e );

protected:
  QVBoxLayout* CApplicationWindowLayout;
  
};

#endif // CAPPLICATIONWINDOW_H

