/*+*****************************************************************************
*                                                                              *
* File: xs.h                                                                   *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)xs.h	1.5	07/22/99	Written by Lionel Cons
 */

#ifndef _xs_h_
#define _xs_h_

/******* Include Files ********************************************************/

#include "host.h"

/******* Constants ************************************************************/

/*
 * flags
 */
#define XS_HUNT		(1 << 0) /* do we hunt to find an unused display? */
#define XS_WANT_TCP	(1 << 1) /* we try to create a TCP server socket */
#define XS_NEED_TCP	(1 << 2) /* we must create a TCP server socket */
#define XS_WANT_UNIX	(1 << 3) /* we try to create a UNIX server socket */
#define XS_NEED_UNIX	(1 << 4) /* we must create a UNIX server socket */

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

/******* Variables ************************************************************/

extern int xs_flags;		/* X socket flags */
extern int xs_fd;		/* fd of the TCP incomming socket */
extern int xs_fdl;		/* fd of the UNIX incomming socket */

/******* Functions ************************************************************/

int  xs_connect(void);
int  xs_connect_local(void);
int  xs_accept(HOST **);
int  xs_accept_local(void);
void xs_setup(char *, int *, char *);
void xs_close(void);

#endif /* _xs_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
