/*+*****************************************************************************
*                                                                              *
* File: xp.h                                                                   *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)xp.h	1.8	02/02/99	Written by Lionel Cons
 */

#ifndef _xp_h_
#define _xp_h_

/******* Include Files ********************************************************/

#include "mc.h"
#include "xmd.h"

/******* Constants ************************************************************/

/*
 * known things that can be traced or printed by xp_trace or xp_print
 */
#define XP_CSETUP	'c'	/* client setup */
#define XP_REQUEST	'r'	/* client request */
#define XP_SSETUP	's'	/* server setup */
#define XP_PACKET	'p'	/* server packet */

/*
 * alert levels
 */
#define AL_INTERNAL	'I'	/* request that may cause internal problem */
#define AL_DUBIOUS	'D'	/* possible security incident */
#define AL_SEVERE	'S'	/* real security incident */

/*
 * number of replies to remember (must be a power of 2)
 */
#define XP_REPMAX	8

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

typedef struct XINFO_ {
  /* X info */
  U8BITS  sex;                  /* byte-sex */
  char    alert_level;		/* alert level (put here for better alignment) */
  U16BITS seq;                  /* sequence number of last request */
  U32BITS resid_base;		/* resource id base */
  U32BITS resid_mask;		/* resource id mask */
  U32BITS sel_req;		/* selection requestor */
  U32BITS sel_prop;		/* selection property */
  U32BITS pkt_count;		/* number of packets exchanged */
  U32BITS pkt_size;		/* size of packets exchanged */
  /* alert info */
  char *alert;			/* alert (reason) or NULL if there is none */
  int   alert_count;		/* number of alerts detected */
  /* reply tracing */
  U16BITS rep_seq[XP_REPMAX];	/* reply sequence numbers */
  U8BITS  rep_type[XP_REPMAX];	/* reply types */
  int     rep_first;		/* first reply in circular buffer */
  int     rep_count;		/* number of replies expected */
  /* fake requests and packets */
  MC *fake_request;		/* fake client request */
  MC *fake_packet;		/* fake server packet */
} XINFO;

/******* Variables ************************************************************/

/******* Functions ************************************************************/

void xp_init(XINFO *);
void xp_noop(char *, XINFO *);
void xp_check(char *, XINFO *);
void xp_trace(char, char *, char *, XINFO *);
#ifdef DEBUG
void xp_print(char, char *, char *, XINFO *);
#endif

#endif /* _xp_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
