/*+*****************************************************************************
*                                                                              *
* File: xmd.h                                                                  *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)xmd.h	1.3	01/16/98	Written by Lionel Cons
 */

#ifndef _xmd_h_
#define _xmd_h_

/******* Include Files ********************************************************/

/******* Constants ************************************************************/

/*
 * simplified per-machine configuration flags (taken from Xmd.h)
 */
#ifdef __alpha
#define LONGIS64BITS		/* 32/64-bit architecture */
#endif

#ifdef __hpux
#ifdef __LP64__
#define LONGIS64BITS
#endif
#endif

#ifdef __sgi
#if (_MIPS_SZLONG == 64)
#define LONGIS64BITS
#endif
#endif

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

/*
 * U*BITS types needed by the X protocol structures
 */
#ifdef LONGIS64BITS
typedef unsigned int   U32BITS;
#else
typedef unsigned long  U32BITS;
#endif
typedef unsigned short U16BITS;
typedef unsigned char  U8BITS;

/*
 * handy macros to print a U32BITS quantity
 */
#ifdef LONGIS64BITS
#define PRId32BITS	"%d"
#define PRIx32BITS	"0x%08X"
#else
#define PRId32BITS	"%ld"
#define PRIx32BITS	"0x%08lX"
#endif

/******* Variables ************************************************************/

/******* Functions ************************************************************/

#endif /* _xmd_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
