/*+*****************************************************************************
*                                                                              *
* File: ui.h                                                                   *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)ui.h	1.5	01/05/98	Written by Lionel Cons
 */

#ifndef _ui_h_
#define _ui_h_

/******* Include Files ********************************************************/

#include <X11/Intrinsic.h>

/******* Constants ************************************************************/

#define NO_INPUT_ID (XtInputId)NULL /* null input id */

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

/*
 * in and out input ids
 */
typedef struct ID_ {
  XtInputId in;			/* read  input id */
  XtInputId out;		/* write input id */
} ID;

/*
 * user interface data
 */
typedef struct UI_ {
  ID cid;			/* client input ids */
  ID sid;			/* server input ids */
  Widget alert;			/* alert dialog */
  Widget info;			/* information box */
  Widget menu;			/* popup menu */
  Widget menu_frozen;		/* popup menu's Frozen widget */
  Widget menu_checked;		/* popup menu's Checked widget */
  Widget menu_safe;		/* popup menu's Safe widget */
} UI;

/******* Variables ************************************************************/

/******* Functions ************************************************************/

void ui_init(UI *);
void ui_close(UI *);

#endif /* _ui_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
