/*+*****************************************************************************
*                                                                              *
* File: io.h                                                                   *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)io.h	1.5	02/01/99	Written by Lionel Cons
 */

#ifndef _io_h_
#define _io_h_

/******* Include Files ********************************************************/

#include "util.h"
#include "mc.h"
#include "xmd.h"

/******* Constants ************************************************************/

#define IO_BUFSIZE	4096	 /* I/O buffer size */

/*
 * I/O flags
*/
#define IO_ERROR	(1 << 0) /* an I/O error occured */
#define IO_READ		(1 << 1) /* have something to read */
#define IO_WRITE	(1 << 2) /* have something to write */

/******* Macros ***************************************************************/

/*
 * round up to a multiple of 4
 */
#define PAD4(x)		(((x)+3) & ~3)

/*
 * CARD8 handling: no sex, no gimmicks
 */
#define getCARD8(b,i)	((U8BITS)(b[i]))
#define putCARD8(b,i,x)	(b[i] = (char)(x))

/******* Types ****************************************************************/

typedef struct IO_ {
  /* general */
  char tag[6];			/* debugging tag */
  char state;			/* state (not used here) */
  int  fd_in;			/* file descriptor to read from */
  int  fd_out;			/* file descriptor to write to */
  int  flags;			/* I/O flags */
  /* in */
  char	buf[IO_BUFSIZE];	/* incomming buffer */
  int pos;			/* position of data in buffer */
  int has;			/* number of bytes in buffer */
  int needs;			/* number of bytes wanted before processing */
  /* out */
  MC *outq_first;		/* first chunk of data in the queue */
  MC *outq_last;		/* last chunk of data in the queue */
} IO;

/******* Variables ************************************************************/

/******* Functions ************************************************************/

void    putCARD16(U8BITS, char *, U16BITS);
U16BITS getCARD16(U8BITS, char *);
void    putCARD32(U8BITS, char *, U32BITS);
U32BITS getCARD32(U8BITS, char *);

void io_init(IO *, int, int);
void io_close(IO *);
void io_read(IO *);
void io_write(IO *);
void io_needs(IO *, char, int);
void io_discard(IO *);
void io_flush(IO *);
void io_queue(IO *, MC *);
void io_unblock(int);
int  io_timeout_read(int, int, void *, int);
int  io_timeout_write(int, int, void *, int);

#endif /* _io_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
